/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientConfigurationEndpointController;
import org.apereo.cas.services.DefaultRegisteredServiceExpirationPolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.registration.client-secret-expiration=PT1H"})
class OidcClientConfigurationEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcClientConfigurationEndpointController")
    protected OidcClientConfigurationEndpointController controller;

    OidcClientConfigurationEndpointControllerTests() {
    }

    @Test
    void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.controller.handleRequestInternal("", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
        mv = this.controller.handleUpdates(UUID.randomUUID().toString(), "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
    }

    @Test
    void verifyServiceNotFoundForUpdate() throws Exception {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("clientConfig");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String clientId = UUID.randomUUID().toString();
        Assertions.assertEquals((int)400, (int)this.controller.handleUpdates(clientId, null, (HttpServletRequest)request, (HttpServletResponse)response).getStatusCode().value());
    }

    @Test
    void verifyGetOperation() {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("clientConfig");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String clientId = UUID.randomUUID().toString();
        OidcRegisteredService service = OidcClientConfigurationEndpointControllerTests.getOidcRegisteredService(clientId);
        service.markAsDynamicallyRegistered();
        service.setExpirationPolicy((RegisteredServiceExpirationPolicy)new DefaultRegisteredServiceExpirationPolicy(ZonedDateTime.now(Clock.systemUTC()).toString()));
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertEquals((int)200, (int)this.controller.handleRequestInternal(clientId, (HttpServletRequest)request, (HttpServletResponse)response).getStatusCode().value());
    }

    @Test
    void verifyUpdateOperation() throws Exception {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("clientConfig");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String clientId = UUID.randomUUID().toString();
        OidcRegisteredService service = OidcClientConfigurationEndpointControllerTests.getOidcRegisteredService(clientId);
        long clientSecretExpiration = ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L).toEpochSecond();
        service.setClientSecretExpiration(clientSecretExpiration);
        this.servicesManager.save((RegisteredService)service);
        String jsonBody = "{\"redirect_uris\": [\"https://apereo.github.io\"],\n\"client_name\": \"Apereo Blog\",\n\"contacts\": [\"cas@example.org\"],\n\"grant_types\": [\"client_credentials\"],\n\"introspection_signed_response_alg\": \"RS256\",\n\"introspection_encrypted_response_alg\": \"RSA1_5\",\n\"introspection_encrypted_response_enc\": \"A128CBC-HS256\"\n}";
        ResponseEntity responseEntity = this.controller.handleUpdates(clientId, "{\"redirect_uris\": [\"https://apereo.github.io\"],\n\"client_name\": \"Apereo Blog\",\n\"contacts\": [\"cas@example.org\"],\n\"grant_types\": [\"client_credentials\"],\n\"introspection_signed_response_alg\": \"RS256\",\n\"introspection_encrypted_response_alg\": \"RSA1_5\",\n\"introspection_encrypted_response_enc\": \"A128CBC-HS256\"\n}", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)200, (int)responseEntity.getStatusCode().value());
        Assertions.assertNotNull((Object)responseEntity.getBody());
        service = (OidcRegisteredService)this.servicesManager.findServiceBy(service.getId(), OidcRegisteredService.class);
        Assertions.assertNotEquals((long)service.getClientSecretExpiration(), (long)clientSecretExpiration);
    }

    @Test
    void verifyBadRequest() {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("clientConfig");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String clientId = UUID.randomUUID().toString();
        Assertions.assertEquals((int)400, (int)this.controller.handleRequestInternal(clientId, (HttpServletRequest)request, (HttpServletResponse)response).getStatusCode().value());
    }
}

