/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import java.util.List;
import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationRequestTranslator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcClientRegistrationRequestTranslatorTests {
    OidcClientRegistrationRequestTranslatorTests() {
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.registration.dynamic-client-registration-mode=OPEN"})
    class OpenRegistrationMode
    extends AbstractOidcTests {
        @Autowired
        @Qualifier(value="oidcClientRegistrationRequestTranslator")
        private OidcClientRegistrationRequestTranslator oidcClientRegistrationRequestTranslator;

        OpenRegistrationMode() {
        }

        @Test
        void verifyBadLogo() throws Exception {
            OidcClientRegistrationRequest registrationRequest = new OidcClientRegistrationRequest();
            registrationRequest.setRedirectUris(List.of("https://apereo.github.io"));
            registrationRequest.setLogo("https://github.com/apereo.can");
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcClientRegistrationRequestTranslator.translate(registrationRequest, Optional.empty()));
        }

        @Test
        void verifyBadPolicy() throws Exception {
            OidcClientRegistrationRequest registrationRequest = new OidcClientRegistrationRequest();
            registrationRequest.setRedirectUris(List.of("https://apereo.github.io"));
            registrationRequest.setPolicyUri("https://github.com/apereo.can");
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcClientRegistrationRequestTranslator.translate(registrationRequest, Optional.empty()));
        }
    }
}

