/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationResponse;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcDynamicClientRegistrationEndpointController;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.registration.client-secret-expiration=P14D"})
class OidcDynamicClientRegistrationEndpointControllerTests
extends AbstractOidcTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    @Qualifier(value="oidcDynamicClientRegistrationEndpointController")
    protected OidcDynamicClientRegistrationEndpointController controller;

    OidcDynamicClientRegistrationEndpointControllerTests() {
    }

    @Test
    void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcDynamicClientRegistrationEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.controller.handleRequestInternal("", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
    }

    @Test
    void verifyBadInput() throws Exception {
        MockHttpServletRequest request = OidcDynamicClientRegistrationEndpointControllerTests.getHttpRequestForEndpoint("register");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertEquals((int)400, (int)this.controller.handleRequestInternal("bad-input", (HttpServletRequest)request, (HttpServletResponse)response).getStatusCode().value());
    }

    @Test
    void verifyBadRedirect() throws Exception {
        String registrationReq = "{   \"redirect_uris\":     [\"https://client.example.org/callback#something\",      \"https://client.example.org/callback2\"],   \"request_uris\":     [\"https://client.example.org/rf.txt#qpXaRLh_n93TTR9F252ValdatUQvQiJi5BDub2BeznA\"]  }";
        MockHttpServletRequest request = OidcDynamicClientRegistrationEndpointControllerTests.getHttpRequestForEndpoint("register");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertEquals((int)400, (int)this.controller.handleRequestInternal("{   \"redirect_uris\":     [\"https://client.example.org/callback#something\",      \"https://client.example.org/callback2\"],   \"request_uris\":     [\"https://client.example.org/rf.txt#qpXaRLh_n93TTR9F252ValdatUQvQiJi5BDub2BeznA\"]  }", (HttpServletRequest)request, (HttpServletResponse)response).getStatusCode().value());
    }

    @Test
    void verifyOperation() throws Exception {
        String registrationReq = "{   \"application_type\": \"web\",   \"default_acr_values\":     [\"mfa-duo\",\"mfa-gauth\"],   \"redirect_uris\":     [\"https://client.example.org/callback\",      \"https://client.example.org/callback2\"],   \"client_name\": \"My Example\",   \"client_name#ja-Japan-JP\":     \"Japanese\",   \"logo_uri\": \"https://client.example.org/logo.png\",   \"policy_uri\": \"https://client.example.org/policy\",   \"tos_uri\": \"https://client.example.org/tos\",   \"subject_type\": \"pairwise\",   \"sector_identifier_uri\":     \"http://localhost:7711\",   \"token_endpoint_auth_method\": \"client_secret_basic\",   \"jwks_uri\": \"https://client.example.org/my_public_keys.jwks\",   \"id_token_signed_response_alg\": \"RS256\",   \"id_token_encrypted_response_alg\": \"RSA1_5\",   \"id_token_encrypted_response_enc\": \"A128CBC-HS256\",   \"userinfo_encrypted_response_alg\": \"RSA1_5\",   \"userinfo_encrypted_response_enc\": \"A128CBC-HS256\",   \"contacts\": [\"ve7jtb@example.org\", \"mary@example.org\"]  }";
        MockHttpServletRequest request = OidcDynamicClientRegistrationEndpointControllerTests.getHttpRequestForEndpoint("register");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String entity = MAPPER.writeValueAsString(List.of("https://client.example.org/callback", "https://client.example.org/callback2"));
        try (MockWebServer webServer = new MockWebServer(7711, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            ResponseEntity responseEntity = this.controller.handleRequestInternal("{   \"application_type\": \"web\",   \"default_acr_values\":     [\"mfa-duo\",\"mfa-gauth\"],   \"redirect_uris\":     [\"https://client.example.org/callback\",      \"https://client.example.org/callback2\"],   \"client_name\": \"My Example\",   \"client_name#ja-Japan-JP\":     \"Japanese\",   \"logo_uri\": \"https://client.example.org/logo.png\",   \"policy_uri\": \"https://client.example.org/policy\",   \"tos_uri\": \"https://client.example.org/tos\",   \"subject_type\": \"pairwise\",   \"sector_identifier_uri\":     \"http://localhost:7711\",   \"token_endpoint_auth_method\": \"client_secret_basic\",   \"jwks_uri\": \"https://client.example.org/my_public_keys.jwks\",   \"id_token_signed_response_alg\": \"RS256\",   \"id_token_encrypted_response_alg\": \"RSA1_5\",   \"id_token_encrypted_response_enc\": \"A128CBC-HS256\",   \"userinfo_encrypted_response_alg\": \"RSA1_5\",   \"userinfo_encrypted_response_enc\": \"A128CBC-HS256\",   \"contacts\": [\"ve7jtb@example.org\", \"mary@example.org\"]  }", (HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((int)201, (int)responseEntity.getStatusCode().value());
            Assertions.assertTrue((((OidcClientRegistrationResponse)responseEntity.getBody()).getClientIdIssuedAt() > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    void verifyNoClientNameOperation() throws Exception {
        String registrationReq = "{   \"application_type\": \"web\",   \"default_acr_values\":     [\"mfa-duo\",\"mfa-gauth\"],   \"redirect_uris\":     [\"https://client.example.org/callback\",      \"https://client.example.org/callback2\"],   \"client_name#ja-Japan-JP\":     \"Japanese\",   \"logo_uri\": \"https://client.example.org/logo.png\",   \"policy_uri\": \"https://client.example.org/policy\",   \"tos_uri\": \"https://client.example.org/tos\",   \"subject_type\": \"pairwise\",   \"sector_identifier_uri\":     \"http://localhost:7711\",   \"token_endpoint_auth_method\": \"client_secret_basic\",   \"jwks\": {\"keys\":[{}]},   \"id_token_signed_response_alg\": \"RS256\",   \"id_token_encrypted_response_alg\": \"RSA1_5\",   \"id_token_encrypted_response_enc\": \"A128CBC-HS256\",   \"userinfo_encrypted_response_alg\": \"RSA1_5\",   \"contacts\": [\"ve7jtb@example.org\", \"mary@example.org\"]  }";
        MockHttpServletRequest request = OidcDynamicClientRegistrationEndpointControllerTests.getHttpRequestForEndpoint("register");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String entity = MAPPER.writeValueAsString(List.of("https://client.example.org/callback", "https://client.example.org/callback2"));
        try (MockWebServer webServer = new MockWebServer(7711, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertEquals((int)201, (int)this.controller.handleRequestInternal("{   \"application_type\": \"web\",   \"default_acr_values\":     [\"mfa-duo\",\"mfa-gauth\"],   \"redirect_uris\":     [\"https://client.example.org/callback\",      \"https://client.example.org/callback2\"],   \"client_name#ja-Japan-JP\":     \"Japanese\",   \"logo_uri\": \"https://client.example.org/logo.png\",   \"policy_uri\": \"https://client.example.org/policy\",   \"tos_uri\": \"https://client.example.org/tos\",   \"subject_type\": \"pairwise\",   \"sector_identifier_uri\":     \"http://localhost:7711\",   \"token_endpoint_auth_method\": \"client_secret_basic\",   \"jwks\": {\"keys\":[{}]},   \"id_token_signed_response_alg\": \"RS256\",   \"id_token_encrypted_response_alg\": \"RSA1_5\",   \"id_token_encrypted_response_enc\": \"A128CBC-HS256\",   \"userinfo_encrypted_response_alg\": \"RSA1_5\",   \"contacts\": [\"ve7jtb@example.org\", \"mary@example.org\"]  }", (HttpServletRequest)request, (HttpServletResponse)response).getStatusCode().value());
        }
    }
}

