/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcInitialAccessTokenController;
import org.apereo.cas.util.EncodingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcInitialAccessTokenControllerTests {
    OidcInitialAccessTokenControllerTests() {
    }

    @TestPropertySource(properties={"cas.authn.oidc.registration.dynamic-client-registration-mode=PROTECTED", "cas.authn.oidc.registration.initial-access-token-user=casuser", "cas.authn.oidc.registration.initial-access-token-password=Mellon"})
    @Nested
    class ProtectedRegistrationTests
    extends AbstractOidcTests {
        @Autowired
        @Qualifier(value="oidcInitialAccessTokenController")
        protected OidcInitialAccessTokenController controller;

        ProtectedRegistrationTests() {
        }

        @Test
        void verifyMismatchedEndpoint() throws Exception {
            MockHttpServletRequest request = ProtectedRegistrationTests.getHttpRequestForEndpoint("unknown/issuer");
            request.setRequestURI("unknown/issuer");
            MockHttpServletResponse response = new MockHttpServletResponse();
            request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"casuser:Mellon")));
            ModelAndView entity = this.controller.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)entity.getStatus());
        }

        @Test
        void verifyPasses() throws Exception {
            MockHttpServletRequest request = ProtectedRegistrationTests.getHttpRequestForEndpoint("initToken");
            MockHttpServletResponse response = new MockHttpServletResponse();
            request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"casuser:Mellon")));
            ModelAndView entity = this.controller.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatus());
            Assertions.assertTrue((boolean)entity.getModel().containsKey("access_token"));
        }

        @Test
        void verifyAuthFails() throws Exception {
            MockHttpServletRequest request = ProtectedRegistrationTests.getHttpRequestForEndpoint("initToken");
            MockHttpServletResponse response = new MockHttpServletResponse();
            request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"casuser:unknown")));
            ModelAndView entity = this.controller.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)entity.getStatus());
        }

        @Test
        void verifyAuthMissing() throws Exception {
            MockHttpServletRequest request = ProtectedRegistrationTests.getHttpRequestForEndpoint("initToken");
            MockHttpServletResponse response = new MockHttpServletResponse();
            ModelAndView entity = this.controller.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)entity.getStatus());
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.registration.dynamic-client-registration-mode=OPEN"})
    @Nested
    class OpenRegistrationTests
    extends AbstractOidcTests {
        @Autowired
        @Qualifier(value="oidcInitialAccessTokenController")
        protected OidcInitialAccessTokenController controller;

        OpenRegistrationTests() {
        }

        @Test
        void verifyNotAllowed() throws Exception {
            MockHttpServletRequest request = OpenRegistrationTests.getHttpRequestForEndpoint("initToken");
            MockHttpServletResponse response = new MockHttpServletResponse();
            ModelAndView entity = this.controller.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((Object)HttpStatus.NOT_ACCEPTABLE, (Object)entity.getStatus());
        }
    }
}

