/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.jwks;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksEndpointController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcJwksEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcJwksController")
    protected OidcJwksEndpointController oidcJwksEndpointController;

    OidcJwksEndpointControllerTests() {
    }

    @Test
    void verifyOperation() {
        MockHttpServletRequest request = OidcJwksEndpointControllerTests.getHttpRequestForEndpoint("jwks");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity result = this.oidcJwksEndpointController.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT.name().toLowerCase(Locale.ENGLISH));
        Assertions.assertTrue((boolean)result.getStatusCode().is2xxSuccessful());
    }

    @Test
    void verifyBadEndpointRequest() {
        MockHttpServletRequest request = OidcJwksEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcJwksEndpointController.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT.name().toLowerCase(Locale.ENGLISH));
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
    }

    @Test
    void verifyFails() {
        MockHttpServletRequest request = OidcJwksEndpointControllerTests.getHttpRequestForEndpoint("jwks");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ((HttpServletResponse)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)response)).setContentType(Mockito.anyString());
        ResponseEntity result = this.oidcJwksEndpointController.handleRequestInternal((HttpServletRequest)request, response, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT.name().toLowerCase(Locale.ENGLISH));
        Assertions.assertTrue((boolean)result.getStatusCode().is4xxClientError());
    }
}

