/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcPostLogoutRedirectUrlMatcher;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.web.support.WebUtils;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
@Import(value={OidcLogoutMatcherTestConfiguration.class})
class OidcLogoutEndpointControllerMatcherTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcLogoutEndpointController")
    protected OidcLogoutEndpointController oidcLogoutEndpointController;

    OidcLogoutEndpointControllerMatcherTests() {
    }

    @Test
    void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerMatcherTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcLogoutEndpointController.handleRequestInternal("", "", "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
    }

    @Test
    void verifyOidcLogoutWithIdTokenAndValidRegExMatchingPostLogoutRedirectUrlParams() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerMatcherTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerMatcherTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("https://www.acme.com/end", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://www.acme.com/end?state=abcd1234&client_id=clientid", (Object)redirectUrl);
        result = this.oidcLogoutEndpointController.handleRequestInternal("https://www.acme.com/done", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://www.acme.com/done?state=abcd1234&client_id=clientid", (Object)redirectUrl);
        result = this.oidcLogoutEndpointController.handleRequestInternal("https://www.acme.org/done", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://oauth.example.org/logout?state=abcd1234&client_id=clientid", (Object)redirectUrl);
    }

    @TestConfiguration(value="OidcLogoutMatcherTestConfiguration", proxyBeanMethods=false)
    static class OidcLogoutMatcherTestConfiguration {
        OidcLogoutMatcherTestConfiguration() {
        }

        @Bean(name={"postLogoutRedirectUrlMatcher"})
        public OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher() {
            return String::matches;
        }
    }
}

