/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcLogoutEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcLogoutEndpointController")
    protected OidcLogoutEndpointController oidcLogoutEndpointController;
    @Autowired
    @Qualifier(value="oidcProtocolEndpointConfigurer")
    private ProtocolEndpointWebSecurityConfigurer<Void> oidcProtocolEndpointConfigurer;

    OidcLogoutEndpointControllerTests() {
    }

    @Test
    void verifyEndpoints() {
        Assertions.assertFalse((boolean)this.oidcProtocolEndpointConfigurer.getIgnoredEndpoints().isEmpty());
    }

    @Test
    void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcLogoutEndpointController.handleRequestInternal("", "", "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
    }

    @Test
    void verifyOidcNoLogoutUrls() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String id = UUID.randomUUID().toString();
        JwtClaims claims = this.getClaims(id);
        OidcRegisteredService oidcRegisteredService = new OidcRegisteredService();
        oidcRegisteredService.setClientId(id);
        oidcRegisteredService.setServiceId("https://example.org");
        oidcRegisteredService.setName(id);
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
    }

    @Test
    void verifyOidcLogoutWithoutParams() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "", "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertNull((Object)redirectUrl);
    }

    @Test
    void verifyOidcLogoutWithStateParam() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "abcd1234", "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertNull((Object)redirectUrl);
    }

    @Test
    void verifyOidcLogoutWithIdTokenParam() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://oauth.example.org/logout?client_id=clientid", (Object)redirectUrl);
    }

    @Test
    void verifyOidcLogoutWithIdTokenAndStateParams() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://oauth.example.org/logout?state=abcd1234&client_id=clientid", (Object)redirectUrl);
    }

    @Test
    void verifyOidcLogoutWithIdTokenAndValidPostLogoutRedirectUrlParams() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("https://logout", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://logout?state=abcd1234&client_id=clientid", (Object)redirectUrl);
    }

    @Test
    void verifyOidcLogoutWithIdTokenAndInvalidPostLogoutRedirectUrlParams() throws Exception {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("https://invalidlogouturl", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCode().value());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://oauth.example.org/logout?state=abcd1234&client_id=clientid", (Object)redirectUrl);
    }
}

