/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.profile;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.profile.OidcUserProfileEndpointController;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcUserProfileEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcProfileController")
    protected OidcUserProfileEndpointController oidcUserProfileEndpointController;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    protected OAuth20AccessTokenFactory accessTokenFactory;

    OidcUserProfileEndpointControllerTests() {
    }

    @Test
    void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcUserProfileEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcUserProfileEndpointController.handlePostRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
    }

    @Test
    void verify() throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("cn", List.of("cas"));
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", map);
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication((Principal)principal);
        OAuth20Code code = this.addCode(principal, (OAuthRegisteredService)OidcUserProfileEndpointControllerTests.getOidcRegisteredService());
        OAuth20AccessToken accessToken = this.accessTokenFactory.create((Service)RegisteredServiceTestUtils.getService(), authentication, (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), code.getId(), code.getClientId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        MockHttpServletRequest mockRequest = OidcUserProfileEndpointControllerTests.getHttpRequestForEndpoint("oidcProfile");
        mockRequest.setMethod(HttpMethod.GET.name());
        mockRequest.setParameter("access_token", accessToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        ResponseEntity entity = this.oidcUserProfileEndpointController.handleGetRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
        entity = this.oidcUserProfileEndpointController.handlePostRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
    }
}

