/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.token;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.dpop.DefaultDPoPProofFactory;
import com.nimbusds.oauth2.sdk.dpop.verifiers.InvalidDPoPProofException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.UUID;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.profile.OidcUserProfileEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcAccessTokenEndpointController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcAccessTokenEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcAccessTokenController")
    protected OidcAccessTokenEndpointController oidcAccessTokenEndpointController;
    @Autowired
    @Qualifier(value="oidcProfileController")
    private OidcUserProfileEndpointController oidcProfileController;

    OidcAccessTokenEndpointControllerTests() {
    }

    @Test
    void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcAccessTokenEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.oidcAccessTokenEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatus());
        mv = this.oidcAccessTokenEndpointController.handleInvalidDPoPProofException((HttpServletResponse)response, (Exception)new InvalidDPoPProofException("invalid"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("error"));
        Assertions.assertEquals((Object)"invalid_dpop_proof", mv.getModel().get("error"));
    }

    @Test
    void verifyClientNoCode() throws Exception {
        MockHttpServletRequest request = OidcAccessTokenEndpointControllerTests.getHttpRequestForEndpoint("oidcAccessToken");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.oidcAccessTokenEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)response.getStatus());
        this.oidcAccessTokenEndpointController.handleGetRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)response.getStatus());
    }

    @Test
    void verifyDPoPRequest() throws Exception {
        ECKey ecJWK = (ECKey)new ECKeyGenerator(Curve.P_256).keyID("1234567890").generate();
        DefaultDPoPProofFactory proofFactory = new DefaultDPoPProofFactory((JWK)ecJWK, JWSAlgorithm.ES256);
        MockHttpServletRequest request = OidcAccessTokenEndpointControllerTests.getHttpRequestForEndpoint("token");
        request.setMethod(HttpMethod.POST.name());
        MockHttpServletResponse response = new MockHttpServletResponse();
        URI uri = new URI(request.getRequestURL().toString());
        SignedJWT dpopProof = proofFactory.createDPoPJWT(HttpMethod.POST.name(), uri);
        String proofJwt = dpopProof.serialize();
        request.addHeader("DPoP", (Object)proofJwt);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser");
        OidcRegisteredService oidcRegisteredService = OidcAccessTokenEndpointControllerTests.getOidcRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        request.addParameter("client_id", oidcRegisteredService.getClientId());
        OAuth20Code code = this.addCode(principal, (OAuthRegisteredService)oidcRegisteredService);
        request.addParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        request.addParameter("redirect_uri", "https://oauth.example.org");
        request.addParameter("code", code.getId());
        this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object());
        ModelAndView mv = this.oidcAccessTokenEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        String accessToken = mv.getModel().get("access_token").toString();
        Assertions.assertNotNull((Object)accessToken);
        JWT dpopAccessToken = JWTParser.parse((String)accessToken);
        Assertions.assertNotNull((Object)dpopAccessToken);
        request = OidcAccessTokenEndpointControllerTests.getHttpRequestForEndpoint("oidcProfile");
        request.setMethod(HttpMethod.POST.name());
        response = new MockHttpServletResponse();
        uri = new URI(request.getRequestURL().toString());
        dpopProof = proofFactory.createDPoPJWT(HttpMethod.POST.name(), uri, (AccessToken)new DPoPAccessToken(accessToken));
        String dpopJwt = dpopProof.serialize();
        request.addHeader("DPoP", (Object)dpopJwt);
        request.addParameter("token", accessToken);
        ResponseEntity entity = this.oidcProfileController.handlePostRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
    }
}

