/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.token;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.token.OidcRevocationEndpointController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcRevocationEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcRevocationEndpointController")
    protected OidcRevocationEndpointController oidcRevocationEndpointController;

    OidcRevocationEndpointControllerTests() {
    }

    @Test
    void verifyGivenAccessTokenInRegistry() throws Exception {
        MockHttpServletRequest request = OidcRevocationEndpointControllerTests.getHttpRequestForEndpoint("revoke");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.oidcRevocationEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)response.getStatus());
        Assertions.assertEquals((Object)"invalid_request", mv.getModel().get("error"));
    }

    @Test
    void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcRevocationEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.oidcRevocationEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatus());
    }
}

