/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.acr-values-supported=mfa-dummy"})
@Import(value={OidcAuthenticationContextTestConfiguration.class})
class OidcAuthenticationContextWebflowEventResolverTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcAuthenticationContextWebflowEventResolver")
    protected CasWebflowEventResolver resolver;
    private MockRequestContext context;

    OidcAuthenticationContextWebflowEventResolverTests() {
    }

    @Override
    @BeforeEach
    public void initialize() throws Exception {
        super.initialize();
        this.context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("385.86.151.11");
        request.setLocalAddr("295.88.151.11");
        request.addHeader("user-agent", (Object)"MSIE");
        request.addParameter("acr_values", "mfa-dummy");
        ClientInfoHolder.setClientInfo((ClientInfo)ClientInfo.from((HttpServletRequest)request));
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        DefaultTargetStateResolver targetResolver = new DefaultTargetStateResolver("mfa-dummy");
        Transition transition = new Transition((TransitionCriteria)new DefaultTransitionCriteria((Expression)new LiteralExpression("mfa-dummy")), (TargetStateResolver)targetResolver);
        this.context.getRootFlow().getGlobalTransitionSet().add(transition);
        WebUtils.putServiceIntoFlowScope((RequestContext)this.context, (Service)CoreAuthenticationTestUtils.getWebApplicationService());
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)this.context);
    }

    @Test
    void verifyOperationNeedsMfa() {
        Set event = this.resolver.resolve((RequestContext)this.context);
        Assertions.assertEquals((int)1, (int)event.size());
        Assertions.assertEquals((Object)"mfa-dummy", (Object)((Event)event.iterator().next()).getId());
    }

    @TestConfiguration(value="OidcAuthenticationContextTestConfiguration", proxyBeanMethods=false)
    static class OidcAuthenticationContextTestConfiguration {
        OidcAuthenticationContextTestConfiguration() {
        }

        @Bean
        public MultifactorAuthenticationProvider dummyProvider() {
            return new TestMultifactorAuthenticationProvider();
        }
    }
}

