/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import java.io.Serializable;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.flow.services.DefaultRegisteredServiceUserInterfaceInfo;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="OIDC")
class OidcRegisteredServiceUIActionTests
extends AbstractOidcTests {
    OidcRegisteredServiceUIActionTests() {
    }

    @BeforeEach
    public void setup() {
        this.servicesManager.deleteAll();
    }

    @Test
    void verifyOidcActionWithoutMDUI() throws Exception {
        MockRequestContext ctx = new MockRequestContext();
        WebUtils.putServiceIntoFlowScope((RequestContext)ctx, null);
        Event event = this.oidcRegisteredServiceUIAction.execute((RequestContext)ctx);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
        Assertions.assertNull((Object)WebUtils.getServiceUserInterfaceMetadata((RequestContext)ctx, Serializable.class));
    }

    @Test
    void verifyOidcActionWithMDUI() throws Exception {
        MockRequestContext ctx = new MockRequestContext();
        this.servicesManager.save((RegisteredService)OidcRegisteredServiceUIActionTests.getOidcRegisteredService());
        WebUtils.putServiceIntoFlowScope((RequestContext)ctx, (Service)RegisteredServiceTestUtils.getService((String)"https://www.example.org?client_id=id&client_secret=secret&redirect_uri=https://oauth.example.org"));
        Event event = this.oidcRegisteredServiceUIAction.execute((RequestContext)ctx);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
        DefaultRegisteredServiceUserInterfaceInfo mdui = (DefaultRegisteredServiceUserInterfaceInfo)WebUtils.getServiceUserInterfaceMetadata((RequestContext)ctx, DefaultRegisteredServiceUserInterfaceInfo.class);
        Assertions.assertNotNull((Object)mdui);
        OidcRegisteredService svc = OidcRegisteredServiceUIActionTests.getOidcRegisteredService();
        Assertions.assertEquals((Object)mdui.getDisplayName(), (Object)svc.getName());
        Assertions.assertEquals((Object)mdui.getInformationURL(), (Object)svc.getInformationUrl());
        Assertions.assertEquals((Object)mdui.getDescription(), (Object)svc.getDescription());
        Assertions.assertEquals((Object)mdui.getPrivacyStatementURL(), (Object)svc.getPrivacyUrl());
        Assertions.assertEquals((Object)mdui.getLogoUrl(), (Object)svc.getLogo());
    }
}

