/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderAbsentException;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@Tag(value="OIDC")
class OidcUnmetAuthenticationRequirementWebflowExceptionHandlerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcUnmetAuthenticationRequirementWebflowExceptionHandler")
    private CasWebflowExceptionHandler oidcUnmetAuthenticationRequirementWebflowExceptionHandler;

    OidcUnmetAuthenticationRequirementWebflowExceptionHandlerTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.servicesManager.save((RegisteredService)OidcUnmetAuthenticationRequirementWebflowExceptionHandlerTests.getOidcRegisteredService());
        String serviceUrl = "https://localhost:8443/cas?redirect_uri=https://oauth.example.org";
        request.addParameter("service", "https://localhost:8443/cas?redirect_uri=https://oauth.example.org");
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        AuthenticationException authException = new AuthenticationException((Throwable)new MultifactorAuthenticationProviderAbsentException());
        Assertions.assertTrue((boolean)this.oidcUnmetAuthenticationRequirementWebflowExceptionHandler.supports((Exception)authException, (RequestContext)context));
        Event event = this.oidcUnmetAuthenticationRequirementWebflowExceptionHandler.handle((Exception)authException, (RequestContext)context);
        Assertions.assertEquals((Object)"redirect", (Object)event.getId());
        String url = context.getRequestScope().get("url").toString();
        Assertions.assertEquals((Object)"https://oauth.example.org?error=unmet_authentication_requirements", (Object)url);
    }
}

