/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.response;

import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcJwtResponseModeCipherExecutorTests
extends AbstractOidcTests {
    OidcJwtResponseModeCipherExecutorTests() {
    }

    @TestPropertySource(properties={"cas.authn.oidc.response.crypto.signing-enabled=true", "cas.authn.oidc.response.crypto.encryption-enabled=true", "cas.authn.oidc.response.crypto.strategy-type=SIGN_AND_ENCRYPT"})
    @Nested
    class SignAndEncryptTests
    extends AbstractOidcTests {
        SignAndEncryptTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            OAuth20AccessToken at = this.getAccessToken();
            String encoded = (String)this.oidcResponseModeJwtCipherExecutor.encode((Object)at.getId());
            Assertions.assertNotNull((Object)encoded);
            String decoded = (String)this.oidcResponseModeJwtCipherExecutor.decode((Object)encoded);
            Assertions.assertNotNull((Object)decoded);
            Assertions.assertEquals((Object)at.getId(), (Object)decoded);
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.response.crypto.signing-enabled=true", "cas.authn.oidc.response.crypto.encryption-enabled=false", "cas.authn.oidc.response.crypto.strategy-type=SIGN_AND_ENCRYPT"})
    @Nested
    class SignOnlyTests
    extends AbstractOidcTests {
        SignOnlyTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            OAuth20AccessToken at = this.getAccessToken();
            String encoded = (String)this.oidcResponseModeJwtCipherExecutor.encode((Object)at.getId());
            Assertions.assertNotNull((Object)encoded);
            String decoded = (String)this.oidcResponseModeJwtCipherExecutor.decode((Object)encoded);
            Assertions.assertNotNull((Object)decoded);
            Assertions.assertEquals((Object)at.getId(), (Object)decoded);
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.response.crypto.signing-enabled=false", "cas.authn.oidc.response.crypto.encryption-enabled=true", "cas.authn.oidc.response.crypto.strategy-type=SIGN_AND_ENCRYPT"})
    @Nested
    class EncryptOnlyTests
    extends AbstractOidcTests {
        EncryptOnlyTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            OAuth20AccessToken at = this.getAccessToken();
            String encoded = (String)this.oidcResponseModeJwtCipherExecutor.encode((Object)at.getId());
            Assertions.assertNotNull((Object)encoded);
            String decoded = (String)this.oidcResponseModeJwtCipherExecutor.decode((Object)encoded);
            Assertions.assertNotNull((Object)decoded);
            Assertions.assertEquals((Object)at.getId(), (Object)decoded);
        }
    }
}

