/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.response;

import java.util.Map;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcResponseModeFormPostJwtBuilderTests {
    OidcResponseModeFormPostJwtBuilderTests() {
    }

    @Nested
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyResponseModeForService() throws Exception {
            OidcRegisteredService registeredService = DefaultTests.getOidcRegisteredService("client");
            this.servicesManager.save((RegisteredService)registeredService);
            OAuth20ResponseModeBuilder builder = this.oauthResponseModeFactory.getBuilder((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.FORM_POST_JWT);
            Assertions.assertNotNull((Object)builder);
            ModelAndView mv = builder.build((RegisteredService)registeredService, "https://apereo.github.io", Map.of("code", "123456", "state", "abcdef"));
            Assertions.assertEquals((Object)"casPostResponseView", (Object)mv.getViewName());
            Assertions.assertEquals((Object)"https://apereo.github.io", (Object)mv.getModelMap().get((Object)"originalUrl"));
            Map params = (Map)mv.getModelMap().get((Object)"parameters");
            Assertions.assertEquals((int)1, (int)params.size());
            Assertions.assertTrue((boolean)params.containsKey("response"));
        }

        @Test
        void verifyResponseModeForDefault() throws Exception {
            OidcRegisteredService registeredService = DefaultTests.getOidcRegisteredService("client").setJwks("");
            this.servicesManager.save((RegisteredService)registeredService);
            OAuth20ResponseModeBuilder builder = this.oauthResponseModeFactory.getBuilder((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.FORM_POST_JWT);
            Assertions.assertNotNull((Object)builder);
            ModelAndView mv = builder.build((RegisteredService)registeredService, "https://apereo.github.io", Map.of("code", "123456", "state", "abcdef"));
            Assertions.assertEquals((Object)"casPostResponseView", (Object)mv.getViewName());
            Assertions.assertEquals((Object)"https://apereo.github.io", (Object)mv.getModelMap().get((Object)"originalUrl"));
            Map params = (Map)mv.getModelMap().get((Object)"parameters");
            Assertions.assertEquals((int)1, (int)params.size());
            Assertions.assertTrue((boolean)params.containsKey("response"));
        }
    }
}

