/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.response;

import java.util.Map;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OIDC")
class OidcResponseModeFragmentJwtBuilderTests
extends AbstractOidcTests {
    OidcResponseModeFragmentJwtBuilderTests() {
    }

    @Test
    void verifyResponseModeForService() throws Exception {
        OidcRegisteredService registeredService = OidcResponseModeFragmentJwtBuilderTests.getOidcRegisteredService("client");
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20ResponseModeBuilder builder = this.oauthResponseModeFactory.getBuilder((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.FRAGMENT_JWT);
        Assertions.assertNotNull((Object)builder);
        ModelAndView mv = builder.build((RegisteredService)registeredService, "https://apereo.github.io", Map.of("code", "123456", "state", "abcdef"));
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
        RedirectView view = (RedirectView)mv.getView();
        URIBuilder urlBuilder = new URIBuilder(view.getUrl());
        Assertions.assertTrue((boolean)urlBuilder.getFragment().startsWith("response="));
    }

    @Test
    void verifyResponseModeForDefault() throws Exception {
        OidcRegisteredService registeredService = OidcResponseModeFragmentJwtBuilderTests.getOidcRegisteredService("client").setJwks("");
        this.servicesManager.save((RegisteredService)registeredService);
        OAuth20ResponseModeBuilder builder = this.oauthResponseModeFactory.getBuilder((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.FRAGMENT_JWT);
        Assertions.assertNotNull((Object)builder);
        ModelAndView mv = builder.build((RegisteredService)registeredService, "https://apereo.github.io", Map.of("code", "123456", "state", "abcdef"));
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
        RedirectView view = (RedirectView)mv.getView();
        URIBuilder urlBuilder = new URIBuilder(view.getUrl());
        Assertions.assertTrue((boolean)urlBuilder.getFragment().startsWith("response="));
    }
}

