/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.response;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Map;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.apereo.cas.token.JwtBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OIDC")
class OidcResponseModeQueryJwtBuilderTests {
    OidcResponseModeQueryJwtBuilderTests() {
    }

    @Nested
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyResponseModeForService() throws Exception {
            OidcRegisteredService registeredService = DefaultTests.getOidcRegisteredService("client");
            this.servicesManager.save((RegisteredService)registeredService);
            OAuth20ResponseModeBuilder builder = this.oauthResponseModeFactory.getBuilder((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.QUERY_JWT);
            Assertions.assertNotNull((Object)builder);
            ModelAndView mv = builder.build((RegisteredService)registeredService, "https://apereo.github.io", Map.of("code", "123456", "state", "abcdef"));
            Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
            RedirectView view = (RedirectView)mv.getView();
            Assertions.assertEquals((Object)"https://apereo.github.io", (Object)view.getUrl());
            Assertions.assertTrue((boolean)mv.getModel().containsKey("response"));
            Assertions.assertEquals((Object)OAuth20ResponseModeTypes.QUERY_JWT, (Object)builder.getResponseMode());
        }

        @Test
        void verifyResponseModeForDefault() throws Exception {
            OidcRegisteredService registeredService = DefaultTests.getOidcRegisteredService("client").setJwks("");
            this.servicesManager.save((RegisteredService)registeredService);
            OAuth20ResponseModeBuilder builder = this.oauthResponseModeFactory.getBuilder((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.QUERY_JWT);
            Assertions.assertNotNull((Object)builder);
            ModelAndView mv = builder.build((RegisteredService)registeredService, "https://apereo.github.io", Map.of("code", "123456", "state", "abcdef"));
            Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
            RedirectView view = (RedirectView)mv.getView();
            Assertions.assertEquals((Object)"https://apereo.github.io", (Object)view.getUrl());
            Assertions.assertTrue((boolean)mv.getModel().containsKey("response"));
            Assertions.assertEquals((Object)OAuth20ResponseModeTypes.QUERY_JWT, (Object)builder.getResponseMode());
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.response.crypto.signing-enabled=false", "cas.authn.oidc.response.crypto.encryption-enabled=false"})
    @Nested
    class DisabledTests
    extends AbstractOidcTests {
        DisabledTests() {
        }

        @Test
        void verifyResponseModeWithoutCrypto() throws Exception {
            OidcRegisteredService registeredService = DisabledTests.getOidcRegisteredService("client").setJwks("");
            this.servicesManager.save((RegisteredService)registeredService);
            OAuth20ResponseModeBuilder builder = this.oauthResponseModeFactory.getBuilder((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.QUERY_JWT);
            Assertions.assertNotNull((Object)builder);
            ModelAndView mv = builder.build((RegisteredService)registeredService, "https://apereo.github.io", Map.of("code", "123456", "state", "abcdef"));
            String response = mv.getModel().get("response").toString();
            JWTClaimsSet claims = JwtBuilder.parse((String)response);
            Assertions.assertNotNull((Object)claims.getClaim("code"));
            Assertions.assertNotNull((Object)claims.getClaim("state"));
        }
    }
}

