/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceResponseBuilder;
import org.apereo.cas.support.openid.web.OpenIdProviderController;
import org.apereo.cas.support.openid.web.mvc.OpenIdValidateController;
import org.apereo.cas.support.openid.web.mvc.SmartOpenIdController;
import org.apereo.cas.support.openid.web.mvc.YadisController;
import org.apereo.cas.support.openid.web.support.OpenIdPostUrlHandlerMapping;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.AbstractDelegateController;
import org.apereo.cas.web.DelegatingController;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.ServiceValidationViewFactory;
import org.apereo.cas.web.ServiceValidationViewFactoryConfigurer;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.View;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Deprecated(since="6.2.0")
@Configuration(value="OpenidConfiguration", proxyBeanMethods=false)
public class OpenIdConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdConfiguration.class);

    @Bean
    public SmartOpenIdController smartOpenIdAssociationController(@Qualifier(value="serverManager") ServerManager serverManager, @Qualifier(value="casOpenIdAssociationSuccessView") View casOpenIdAssociationSuccessView) {
        return new SmartOpenIdController(serverManager, casOpenIdAssociationSuccessView);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"serverManager"})
    public ServerManager serverManager(CasConfigurationProperties casProperties) {
        ServerManager manager = new ServerManager();
        manager.setOPEndpointUrl(casProperties.getServer().getLoginUrl());
        manager.setEnforceRpId(casProperties.getAuthn().getOpenid().isEnforceRpId());
        manager.setSharedAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
        LOGGER.trace("Creating openid server manager with OP endpoint [{}]", (Object)casProperties.getServer().getLoginUrl());
        return manager;
    }

    @ConditionalOnMissingBean(name={"openIdServiceResponseBuilder"})
    @Bean
    public ResponseBuilder openIdServiceResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="serverManager") ServerManager serverManager, @Qualifier(value="urlValidator") UrlValidator urlValidator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        String openIdPrefixUrl = casProperties.getServer().getPrefix().concat("/openid");
        return new OpenIdServiceResponseBuilder(openIdPrefixUrl, serverManager, centralAuthenticationService, servicesManager, urlValidator);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"yadisController"})
    public YadisController yadisController() {
        return new YadisController();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public OpenIdProviderController openIdProviderController() {
        return new OpenIdProviderController();
    }

    @Bean
    public OpenIdValidateController openIdValidateController(CasConfigurationProperties casProperties, @Qualifier(value="serverManager") ServerManager serverManager, @Qualifier(value="serviceValidationViewFactory") ServiceValidationViewFactory serviceValidationViewFactory, @Qualifier(value="proxy20Handler") ProxyHandler proxy20Handler, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="requestedContextValidator") RequestedAuthenticationContextValidator requestedContextValidator, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification") CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="serviceValidationAuthorizers") ServiceTicketValidationAuthorizersExecutionPlan validationAuthorizers) {
        ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().validationSpecifications(CollectionUtils.wrapSet((Object)cas20WithoutProxyProtocolValidationSpecification)).authenticationSystemSupport(authenticationSystemSupport).servicesManager(servicesManager).centralAuthenticationService(centralAuthenticationService).argumentExtractor(argumentExtractor).proxyHandler(proxy20Handler).requestedContextValidator(requestedContextValidator).authnContextAttribute(casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute()).validationAuthorizers(validationAuthorizers).renewEnabled(casProperties.getSso().isRenewAuthnEnabled()).validationViewFactory(serviceValidationViewFactory).build();
        return new OpenIdValidateController(context, serverManager);
    }

    @Bean
    public OpenIdPostUrlHandlerMapping openIdPostUrlHandlerMapping(@Qualifier(value="smartOpenIdAssociationController") SmartOpenIdController smartOpenIdAssociationController, @Qualifier(value="openIdValidateController") OpenIdValidateController openIdValidateController) {
        DelegatingController controller = new DelegatingController();
        controller.setDelegates(CollectionUtils.wrapList((Object[])new AbstractDelegateController[]{smartOpenIdAssociationController, openIdValidateController}));
        OpenIdPostUrlHandlerMapping m = new OpenIdPostUrlHandlerMapping();
        m.setOrder(1);
        Properties mappings = new Properties();
        mappings.put("/login", (Object)controller);
        m.setMappings(mappings);
        return m;
    }

    @Bean
    public ServiceValidationViewFactoryConfigurer openIdServiceValidationViewFactoryConfigurer(@Qualifier(value="casOpenIdServiceSuccessView") View casOpenIdServiceSuccessView, @Qualifier(value="casOpenIdServiceFailureView") View casOpenIdServiceFailureView) {
        return factory -> factory.registerView(OpenIdValidateController.class, Pair.of((Object)casOpenIdServiceSuccessView, (Object)casOpenIdServiceFailureView));
    }

    @Configuration(value="OpenIdProtocolViews", proxyBeanMethods=false)
    public static class OpenIdProtocolViews {
        @Bean
        @Scope(value="prototype")
        public View casOpenIdServiceFailureView(ConfigurableApplicationContext applicationContext, @Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory) {
            return casProtocolViewFactory.create(applicationContext, "protocol/openid/casOpenIdServiceFailureView");
        }

        @Bean
        @Scope(value="prototype")
        public View casOpenIdServiceSuccessView(ConfigurableApplicationContext applicationContext, @Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory) {
            return casProtocolViewFactory.create(applicationContext, "protocol/openid/casOpenIdServiceSuccessView");
        }

        @Bean
        @Scope(value="prototype")
        public View casOpenIdAssociationSuccessView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, "protocol/openid/casOpenIdAssociationSuccessView");
        }

        @Bean
        @Scope(value="prototype")
        public View openIdProviderView(ConfigurableApplicationContext applicationContext, @Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory) {
            return casProtocolViewFactory.create(applicationContext, "protocol/openid/user");
        }
    }
}

