/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.support.openid.OpenIdProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.handler.support.OpenIdCredentialsAuthenticationHandler;
import org.apereo.cas.support.openid.authentication.principal.OpenIdPrincipalResolver;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Deprecated(since="6.2.0")
@Configuration(value="OpenIdAuthenticationEventExecutionPlanConfiguration", proxyBeanMethods=false)
public class OpenIdAuthenticationEventExecutionPlanConfiguration {
    @Bean
    public AuthenticationHandler openIdCredentialsAuthenticationHandler(CasConfigurationProperties casProperties, @Qualifier(value="openidPrincipalFactory") PrincipalFactory openidPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
        OpenIdProperties openid = casProperties.getAuthn().getOpenid();
        return new OpenIdCredentialsAuthenticationHandler(openid.getName(), servicesManager, openidPrincipalFactory, ticketRegistry, openid.getOrder());
    }

    @Bean
    public OpenIdPrincipalResolver openIdPrincipalResolver(CasConfigurationProperties casProperties, @Qualifier(value="openidPrincipalFactory") PrincipalFactory openidPrincipalFactory, @Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository) {
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        PersonDirectoryPrincipalResolverProperties principal = casProperties.getAuthn().getOpenid().getPrincipal();
        return (OpenIdPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)openidPrincipalFactory, (IPersonAttributeDao)attributeRepository, (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), OpenIdPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
    }

    @ConditionalOnMissingBean(name={"openidPrincipalFactory"})
    @Bean
    public PrincipalFactory openidPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"openIdAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer openIdAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="openIdCredentialsAuthenticationHandler") AuthenticationHandler openIdCredentialsAuthenticationHandler, @Qualifier(value="openIdPrincipalResolver") OpenIdPrincipalResolver openIdPrincipalResolver) {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(openIdCredentialsAuthenticationHandler, (PrincipalResolver)openIdPrincipalResolver);
    }
}

