/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AbstractAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.metadata.BasicCredentialMetaData;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.principal.OpenIdCredential;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;

@Deprecated(since="6.2.0")
public class OpenIdCredentialsAuthenticationHandler
extends AbstractAuthenticationHandler {
    private final TicketRegistry ticketRegistry;

    public OpenIdCredentialsAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, TicketRegistry ticketRegistry, Integer order) {
        super(name, servicesManager, principalFactory, order);
        this.ticketRegistry = ticketRegistry;
    }

    public AuthenticationHandlerExecutionResult authenticate(Credential credential) throws GeneralSecurityException {
        OpenIdCredential c = (OpenIdCredential)credential;
        TicketGrantingTicket t = (TicketGrantingTicket)this.ticketRegistry.getTicket(c.getTicketGrantingTicketId(), TicketGrantingTicket.class);
        if (t == null || t.isExpired()) {
            throw new FailedLoginException("Ticket-granting ticket is null or expired.");
        }
        Principal principal = t.getAuthentication().getPrincipal();
        if (!principal.getId().equals(c.getUsername())) {
            throw new FailedLoginException("Principal ID mismatch");
        }
        return new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData((Credential)c), principal);
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return OpenIdCredential.class.isAssignableFrom(clazz);
    }

    public boolean supports(Credential credential) {
        return credential instanceof OpenIdCredential;
    }
}

