/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.handler.support;

import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.authentication.principal.OpenIdCredential;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Deprecated(since="6.2.0")
@Tag(value="AuthenticationHandler")
public class OpenIdCredentialsAuthenticationHandlerTests
extends AbstractOpenIdTests {
    private static final String TGT_ID = "test";
    private static final String USERNAME = "test";
    @Autowired
    @Qualifier(value="openIdCredentialsAuthenticationHandler")
    private AuthenticationHandler openIdCredentialsAuthenticationHandler;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;

    @Test
    public void verifySupports() {
        Assertions.assertTrue((boolean)this.openIdCredentialsAuthenticationHandler.supports((Credential)new OpenIdCredential("test", "test")));
        Assertions.assertFalse((boolean)this.openIdCredentialsAuthenticationHandler.supports((Credential)new UsernamePasswordCredential()));
    }

    @Test
    public void verifyTGTWithSameId() throws Exception {
        OpenIdCredential c = new OpenIdCredential("test", "test");
        TicketGrantingTicket t = OpenIdCredentialsAuthenticationHandlerTests.getTicketGrantingTicket();
        this.ticketRegistry.addTicket((Ticket)t);
        Assertions.assertEquals((Object)"test", (Object)this.openIdCredentialsAuthenticationHandler.authenticate((Credential)c).getPrincipal().getId());
    }

    @Test
    public void verifyTGTThatIsExpired() throws Exception {
        OpenIdCredential c = new OpenIdCredential("test", "test");
        TicketGrantingTicket t = OpenIdCredentialsAuthenticationHandlerTests.getTicketGrantingTicket();
        this.ticketRegistry.addTicket((Ticket)t);
        t.markTicketExpired();
        this.ticketRegistry.updateTicket((Ticket)t);
        Assertions.assertThrows(FailedLoginException.class, () -> this.openIdCredentialsAuthenticationHandler.authenticate((Credential)c));
    }

    @Test
    public void verifyTGTWithDifferentId() throws Exception {
        OpenIdCredential c = new OpenIdCredential("test", "test1");
        TicketGrantingTicket t = OpenIdCredentialsAuthenticationHandlerTests.getTicketGrantingTicket();
        this.ticketRegistry.addTicket((Ticket)t);
        Assertions.assertThrows(FailedLoginException.class, () -> this.openIdCredentialsAuthenticationHandler.authenticate((Credential)c));
    }

    private static TicketGrantingTicket getTicketGrantingTicket() {
        return new TicketGrantingTicketImpl("test", CoreAuthenticationTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L));
    }
}

