/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.mvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.web.mvc.OpenIdValidateController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.message.VerifyResponse;
import org.openid4java.server.ServerManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Deprecated(since="6.3.0")
@Tag(value="Simple")
@Import(value={OpenIdValidateControllerTestConfiguration.class})
public class OpenIdValidateControllerTests
extends AbstractOpenIdTests {
    private final MockHttpServletRequest request = new MockHttpServletRequest();
    private final HttpServletResponse response = new MockHttpServletResponse();
    @Autowired
    @Qualifier(value="casOpenIdServiceSuccessView")
    private View casOpenIdServiceSuccessView;
    @Autowired
    @Qualifier(value="casOpenIdServiceFailureView")
    private View casOpenIdServiceFailureView;
    @Autowired
    @Qualifier(value="openIdValidateController")
    private OpenIdValidateController controller;

    @Test
    public void verifySuccess() throws Exception {
        Assertions.assertFalse((boolean)this.controller.canHandle((HttpServletRequest)this.request, this.response));
        this.request.addParameter("openid.mode", "check_authentication");
        Assertions.assertTrue((boolean)this.controller.canHandle((HttpServletRequest)this.request, this.response));
        this.request.setParameter("pass", "true");
        ModelAndView mv = this.controller.handleRequestInternal((HttpServletRequest)this.request, this.response);
        Assertions.assertEquals((Object)this.casOpenIdServiceSuccessView.toString(), (Object)mv.getView().toString());
        this.request.setParameter("pass", "false");
        mv = this.controller.handleRequestInternal((HttpServletRequest)this.request, this.response);
        Assertions.assertEquals((Object)this.casOpenIdServiceFailureView.toString(), (Object)mv.getView().toString());
    }

    @TestConfiguration(value="OpenIdValidateControllerTestConfiguration", proxyBeanMethods=false)
    public static class OpenIdValidateControllerTestConfiguration {
        @Bean
        public ServerManager serverManager() {
            ServerManager mock = (ServerManager)Mockito.mock(ServerManager.class);
            VerifyResponse message = (VerifyResponse)Mockito.mock(VerifyResponse.class);
            Mockito.when((Object)message.isSignatureVerified()).thenReturn((Object)Boolean.TRUE);
            Mockito.when((Object)mock.verify((ParameterList)Mockito.argThat(arg -> arg != null && arg.getParameterValue("pass").equals("true")))).thenReturn((Object)message);
            Mockito.when((Object)mock.verify((ParameterList)Mockito.argThat(arg -> arg != null && arg.getParameterValue("pass").equals("false")))).thenReturn((Object)((Message)Mockito.mock(VerifyResponse.class)));
            return mock;
        }
    }
}

