/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.api.PasswordlessTokenRepository;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.PasswordlessTokenAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.passwordless.PasswordlessAuthenticationProperties;
import org.apereo.cas.impl.account.GroovyPasswordlessUserAccountStore;
import org.apereo.cas.impl.account.RestfulPasswordlessUserAccountStore;
import org.apereo.cas.impl.account.SimplePasswordlessUserAccountStore;
import org.apereo.cas.impl.token.InMemoryPasswordlessTokenRepository;
import org.apereo.cas.impl.token.PasswordlessTokenCipherExecutor;
import org.apereo.cas.impl.token.RestfulPasswordlessTokenRepository;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="passwordlessAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordlessAuthenticationConfiguration {
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;

    @Bean
    public PrincipalFactory passwordlessPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"passwordlessTokenAuthenticationHandler"})
    public AuthenticationHandler passwordlessTokenAuthenticationHandler() {
        return new PasswordlessTokenAuthenticationHandler(null, (ServicesManager)this.servicesManager.getObject(), this.passwordlessPrincipalFactory(), null, this.passwordlessTokenRepository());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"passwordlessUserAccountStore"})
    public PasswordlessUserAccountStore passwordlessUserAccountStore() {
        PasswordlessAuthenticationProperties.Accounts accounts = this.casProperties.getAuthn().getPasswordless().getAccounts();
        if (accounts.getGroovy().getLocation() != null) {
            return new GroovyPasswordlessUserAccountStore(accounts.getGroovy().getLocation());
        }
        if (StringUtils.isNotBlank((CharSequence)accounts.getRest().getUrl())) {
            return new RestfulPasswordlessUserAccountStore(accounts.getRest());
        }
        Map<String, PasswordlessUserAccount> simple = accounts.getSimple().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            PasswordlessUserAccount account = new PasswordlessUserAccount();
            account.setUsername((String)entry.getKey());
            account.setName((String)entry.getKey());
            if (EmailValidator.getInstance().isValid((String)entry.getValue())) {
                account.setEmail((String)entry.getValue());
            } else {
                account.setPhone((String)entry.getValue());
            }
            return account;
        }));
        return new SimplePasswordlessUserAccountStore(simple);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"passwordlessCipherExecutor"})
    public CipherExecutor passwordlessCipherExecutor() {
        PasswordlessAuthenticationProperties.Tokens tokens = this.casProperties.getAuthn().getPasswordless().getTokens();
        EncryptionJwtSigningJwtCryptographyProperties crypto = tokens.getRest().getCrypto();
        if (crypto.isEnabled()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, PasswordlessTokenCipherExecutor.class);
        }
        return CipherExecutor.noOpOfSerializableToString();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"passwordlessTokenRepository"})
    public PasswordlessTokenRepository passwordlessTokenRepository() {
        PasswordlessAuthenticationProperties.Tokens tokens = this.casProperties.getAuthn().getPasswordless().getTokens();
        if (StringUtils.isNotBlank((CharSequence)tokens.getRest().getUrl())) {
            return new RestfulPasswordlessTokenRepository(tokens.getExpireInSeconds(), tokens.getRest(), (CipherExecutor<Serializable, String>)this.passwordlessCipherExecutor());
        }
        return new InMemoryPasswordlessTokenRepository(tokens.getExpireInSeconds());
    }

    @ConditionalOnMissingBean(name={"passwordlessAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer passwordlessAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.passwordlessTokenAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
    }
}

