/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.account;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.configuration.model.support.passwordless.account.PasswordlessAuthenticationRestAccountsProperties;
import org.apereo.cas.util.HttpUtils;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulPasswordlessUserAccountStore
implements PasswordlessUserAccountStore {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulPasswordlessUserAccountStore.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules().configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final PasswordlessAuthenticationRestAccountsProperties restProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<PasswordlessUserAccount> findUser(String username) {
        HttpResponse response = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", username);
            response = HttpUtils.execute((String)this.restProperties.getUrl(), (String)this.restProperties.getMethod(), (String)this.restProperties.getBasicAuthUsername(), (String)this.restProperties.getBasicAuthPassword(), parameters, new HashMap(0));
            if (response != null && response.getEntity() != null) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                PasswordlessUserAccount account = (PasswordlessUserAccount)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), PasswordlessUserAccount.class);
                Optional<PasswordlessUserAccount> optional = Optional.ofNullable(account);
                HttpUtils.close((HttpResponse)response);
                return optional;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
        }
        finally {
            HttpUtils.close(response);
        }
        return Optional.empty();
    }

    @Generated
    public RestfulPasswordlessUserAccountStore(PasswordlessAuthenticationRestAccountsProperties restProperties) {
        this.restProperties = restProperties;
    }
}

