/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.token;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.impl.token.BasePasswordlessTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryPasswordlessTokenRepository
extends BasePasswordlessTokenRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryPasswordlessTokenRepository.class);
    private static final int INITIAL_CACHE_SIZE = 50;
    private static final long MAX_CACHE_SIZE = 100000000L;
    private final LoadingCache<String, String> storage;

    public InMemoryPasswordlessTokenRepository(int tokenExpirationInSeconds) {
        super(tokenExpirationInSeconds);
        this.storage = Caffeine.newBuilder().initialCapacity(50).maximumSize(100000000L).expireAfterWrite(Duration.ofSeconds(tokenExpirationInSeconds)).build(s -> {
            LOGGER.error("Load operation of the cache is not supported.");
            return null;
        });
    }

    @Override
    public Optional<String> findToken(String username) {
        return Optional.ofNullable((String)this.storage.getIfPresent((Object)username));
    }

    @Override
    public void deleteTokens(String username) {
        this.storage.invalidate((Object)username);
    }

    @Override
    public void deleteToken(String username, String token) {
        this.deleteTokens(username);
    }

    @Override
    public void saveToken(String username, String token) {
        this.storage.put((Object)username, (Object)token);
    }

    @Override
    public void clean() {
        this.storage.cleanUp();
    }
}

