/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.token;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.model.support.passwordless.token.PasswordlessAuthenticationRestTokensProperties;
import org.apereo.cas.impl.token.BasePasswordlessTokenRepository;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class RestfulPasswordlessTokenRepository
extends BasePasswordlessTokenRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulPasswordlessTokenRepository.class);
    private final PasswordlessAuthenticationRestTokensProperties restProperties;
    private final CipherExecutor cipherExecutor;

    public RestfulPasswordlessTokenRepository(int tokenExpirationInSeconds, PasswordlessAuthenticationRestTokensProperties restProperties, CipherExecutor<Serializable, String> cipherExecutor) {
        super(tokenExpirationInSeconds);
        this.restProperties = restProperties;
        this.cipherExecutor = cipherExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> findToken(String username) {
        HttpResponse response = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", username);
            response = HttpUtils.execute((String)this.restProperties.getUrl(), (String)HttpMethod.GET.name(), (String)this.restProperties.getBasicAuthUsername(), (String)this.restProperties.getBasicAuthPassword(), parameters, new HashMap(0));
            if (response != null && response.getEntity() != null) {
                String token = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                String result = this.cipherExecutor.decode((Object)token).toString();
                Optional<String> optional = Optional.of(result);
                HttpUtils.close((HttpResponse)response);
                return optional;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
        }
        finally {
            HttpUtils.close(response);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTokens(String username) {
        HttpResponse response = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", username);
            response = HttpUtils.execute((String)this.restProperties.getUrl(), (String)HttpMethod.DELETE.name(), (String)this.restProperties.getBasicAuthUsername(), (String)this.restProperties.getBasicAuthPassword(), parameters, new HashMap(0));
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
        }
        finally {
            HttpUtils.close(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteToken(String username, String token) {
        HttpResponse response = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", username);
            parameters.put("token", this.cipherExecutor.encode((Object)token).toString());
            response = HttpUtils.execute((String)this.restProperties.getUrl(), (String)HttpMethod.DELETE.name(), (String)this.restProperties.getBasicAuthUsername(), (String)this.restProperties.getBasicAuthPassword(), parameters, new HashMap(0));
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
        }
        finally {
            HttpUtils.close(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToken(String username, String token) {
        HttpResponse response = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", username);
            parameters.put("token", this.cipherExecutor.encode((Object)token).toString());
            response = HttpUtils.execute((String)this.restProperties.getUrl(), (String)HttpMethod.POST.name(), (String)this.restProperties.getBasicAuthUsername(), (String)this.restProperties.getBasicAuthPassword(), parameters, new HashMap(0));
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
        }
        finally {
            HttpUtils.close(response);
        }
    }

    @Override
    public void clean() {
        HttpResponse response = null;
        try {
            response = HttpUtils.execute((String)this.restProperties.getUrl(), (String)HttpMethod.DELETE.name(), (String)this.restProperties.getBasicAuthUsername(), (String)this.restProperties.getBasicAuthPassword(), new HashMap(0), new HashMap(0));
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
        }
        finally {
            HttpUtils.close(response);
        }
    }
}

