/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.api.PasswordlessTokenRepository;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.PasswordlessTokenAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.passwordless.PasswordlessAuthenticationAccountsProperties;
import org.apereo.cas.configuration.model.support.passwordless.PasswordlessAuthenticationTokensProperties;
import org.apereo.cas.impl.account.GroovyPasswordlessUserAccountStore;
import org.apereo.cas.impl.account.JsonPasswordlessUserAccountStore;
import org.apereo.cas.impl.account.RestfulPasswordlessUserAccountStore;
import org.apereo.cas.impl.account.SimplePasswordlessUserAccountStore;
import org.apereo.cas.impl.token.InMemoryPasswordlessTokenRepository;
import org.apereo.cas.impl.token.PasswordlessTokenCipherExecutor;
import org.apereo.cas.impl.token.RestfulPasswordlessTokenRepository;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="PasswordlessAuthenticationConfiguration", proxyBeanMethods=false)
public class PasswordlessAuthenticationConfiguration {
    @Bean
    public PrincipalFactory passwordlessPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"passwordlessTokenAuthenticationHandler"})
    public AuthenticationHandler passwordlessTokenAuthenticationHandler(@Qualifier(value="passwordlessPrincipalFactory") PrincipalFactory passwordlessPrincipalFactory, @Qualifier(value="passwordlessTokenRepository") PasswordlessTokenRepository passwordlessTokenRepository, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        return new PasswordlessTokenAuthenticationHandler(null, servicesManager, passwordlessPrincipalFactory, null, passwordlessTokenRepository);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"passwordlessUserAccountStore"})
    public PasswordlessUserAccountStore passwordlessUserAccountStore(CasConfigurationProperties casProperties) {
        PasswordlessAuthenticationAccountsProperties accounts = casProperties.getAuthn().getPasswordless().getAccounts();
        if (accounts.getJson().getLocation() != null) {
            return new JsonPasswordlessUserAccountStore(accounts.getJson().getLocation());
        }
        if (accounts.getGroovy().getLocation() != null) {
            return new GroovyPasswordlessUserAccountStore(accounts.getGroovy().getLocation());
        }
        if (StringUtils.isNotBlank((CharSequence)accounts.getRest().getUrl())) {
            return new RestfulPasswordlessUserAccountStore(accounts.getRest());
        }
        Map<String, PasswordlessUserAccount> simple = accounts.getSimple().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            PasswordlessUserAccount account = new PasswordlessUserAccount();
            account.setUsername((String)entry.getKey());
            account.setName((String)entry.getKey());
            if (EmailValidator.getInstance().isValid((String)entry.getValue())) {
                account.setEmail((String)entry.getValue());
            } else {
                account.setPhone((String)entry.getValue());
            }
            return account;
        }));
        return new SimplePasswordlessUserAccountStore(simple);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"passwordlessCipherExecutor"})
    public CipherExecutor passwordlessCipherExecutor(CasConfigurationProperties casProperties) {
        PasswordlessAuthenticationTokensProperties tokens = casProperties.getAuthn().getPasswordless().getTokens();
        EncryptionJwtSigningJwtCryptographyProperties crypto = tokens.getCrypto();
        if (crypto.isEnabled()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, PasswordlessTokenCipherExecutor.class);
        }
        return CipherExecutor.noOpOfSerializableToString();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"passwordlessTokenRepository"})
    public PasswordlessTokenRepository passwordlessTokenRepository(CasConfigurationProperties casProperties, @Qualifier(value="passwordlessCipherExecutor") CipherExecutor passwordlessCipherExecutor) {
        PasswordlessAuthenticationTokensProperties tokens = casProperties.getAuthn().getPasswordless().getTokens();
        if (StringUtils.isNotBlank((CharSequence)tokens.getRest().getUrl())) {
            return new RestfulPasswordlessTokenRepository(tokens.getExpireInSeconds(), tokens.getRest(), (CipherExecutor<Serializable, String>)passwordlessCipherExecutor);
        }
        return new InMemoryPasswordlessTokenRepository(tokens.getExpireInSeconds());
    }

    @ConditionalOnMissingBean(name={"passwordlessAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer passwordlessAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="passwordlessTokenAuthenticationHandler") AuthenticationHandler passwordlessTokenAuthenticationHandler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(passwordlessTokenAuthenticationHandler, defaultPrincipalResolver);
    }
}

