/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.account;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.configuration.model.support.passwordless.account.PasswordlessAuthenticationRestAccountsProperties;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class RestfulPasswordlessUserAccountStore
implements PasswordlessUserAccountStore {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulPasswordlessUserAccountStore.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final PasswordlessAuthenticationRestAccountsProperties restProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<PasswordlessUserAccount> findUser(String username) {
        HttpResponse response = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", username);
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(this.restProperties.getBasicAuthPassword()).basicAuthUsername(this.restProperties.getBasicAuthUsername()).method(HttpMethod.valueOf((String)this.restProperties.getMethod().toUpperCase().trim())).url(this.restProperties.getUrl()).parameters(parameters).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            if (response != null && response.getEntity() != null) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                PasswordlessUserAccount account = (PasswordlessUserAccount)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), PasswordlessUserAccount.class);
                Optional<PasswordlessUserAccount> optional = Optional.ofNullable(account);
                HttpUtils.close((HttpResponse)response);
                return optional;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return Optional.empty();
    }

    @Generated
    public RestfulPasswordlessUserAccountStore(PasswordlessAuthenticationRestAccountsProperties restProperties) {
        this.restProperties = restProperties;
    }
}

