/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.token;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Optional;
import org.apereo.cas.impl.token.BasePasswordlessTokenRepository;

public class InMemoryPasswordlessTokenRepository
extends BasePasswordlessTokenRepository {
    private static final int INITIAL_CACHE_SIZE = 50;
    private static final long MAX_CACHE_SIZE = 100000000L;
    private final Cache<String, String> storage;

    public InMemoryPasswordlessTokenRepository(int tokenExpirationInSeconds) {
        super(tokenExpirationInSeconds);
        this.storage = Caffeine.newBuilder().initialCapacity(50).maximumSize(100000000L).expireAfterWrite(Duration.ofSeconds(tokenExpirationInSeconds)).build();
    }

    @Override
    public Optional<String> findToken(String username) {
        return Optional.ofNullable((String)this.storage.getIfPresent((Object)username));
    }

    @Override
    public void deleteTokens(String username) {
        this.storage.invalidate((Object)username);
    }

    @Override
    public void deleteToken(String username, String token) {
        this.deleteTokens(username);
    }

    @Override
    public void saveToken(String username, String token) {
        this.storage.put((Object)username, (Object)token);
    }

    @Override
    public void clean() {
        this.storage.cleanUp();
    }
}

