/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.token;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import lombok.Generated;
import org.springframework.data.annotation.Id;

@MappedSuperclass
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class PasswordlessAuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 3810773120720229099L;
    @Id
    @Transient
    @JsonProperty
    private long id;
    @Column(nullable=false)
    private String username;
    @Column(nullable=false)
    private String token;
    @Column(name="EXP_DATE", length=0x7FFFFFFF, nullable=false)
    private ZonedDateTime expirationDate;

    @JsonIgnore
    public boolean isExpired() {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return now.isAfter(this.getExpirationDate()) || now.isEqual(this.getExpirationDate());
    }

    @Generated
    public static PasswordlessAuthenticationTokenBuilder builder() {
        return new PasswordlessAuthenticationTokenBuilder();
    }

    @Generated
    public String toString() {
        return "PasswordlessAuthenticationToken(id=" + this.id + ", username=" + this.username + ", token=" + this.token + ", expirationDate=" + this.expirationDate + ")";
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public ZonedDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty
    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setExpirationDate(ZonedDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Generated
    public PasswordlessAuthenticationToken(long id, String username, String token, ZonedDateTime expirationDate) {
        this.id = id;
        this.username = username;
        this.token = token;
        this.expirationDate = expirationDate;
    }

    @Generated
    public PasswordlessAuthenticationToken() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PasswordlessAuthenticationToken)) {
            return false;
        }
        PasswordlessAuthenticationToken other = (PasswordlessAuthenticationToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$token = this.token;
        String other$token = other.token;
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        ZonedDateTime this$expirationDate = this.expirationDate;
        ZonedDateTime other$expirationDate = other.expirationDate;
        return !(this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PasswordlessAuthenticationToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.id;
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $token = this.token;
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        ZonedDateTime $expirationDate = this.expirationDate;
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        return result;
    }

    @Generated
    public static class PasswordlessAuthenticationTokenBuilder {
        @Generated
        private long id;
        @Generated
        private String username;
        @Generated
        private String token;
        @Generated
        private ZonedDateTime expirationDate;

        @Generated
        PasswordlessAuthenticationTokenBuilder() {
        }

        @JsonProperty
        @Generated
        public PasswordlessAuthenticationTokenBuilder id(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public PasswordlessAuthenticationTokenBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public PasswordlessAuthenticationTokenBuilder token(String token) {
            this.token = token;
            return this;
        }

        @Generated
        public PasswordlessAuthenticationTokenBuilder expirationDate(ZonedDateTime expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Generated
        public PasswordlessAuthenticationToken build() {
            return new PasswordlessAuthenticationToken(this.id, this.username, this.token, this.expirationDate);
        }

        @Generated
        public String toString() {
            return "PasswordlessAuthenticationToken.PasswordlessAuthenticationTokenBuilder(id=" + this.id + ", username=" + this.username + ", token=" + this.token + ", expirationDate=" + this.expirationDate + ")";
        }
    }
}

