/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.pm;

import java.io.Serializable;
import javax.sql.DataSource;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.jdbc.JdbcPasswordManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="jdbcPasswordManagementConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class JdbcPasswordManagementConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="passwordManagementCipherExecutor")
    private CipherExecutor passwordManagementCipherExecutor;

    @Bean
    public DataSource jdbcPasswordManagementDataSource() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getAuthn().getPm().getJdbc());
    }

    @RefreshScope
    @Bean
    public PasswordManagementService passwordChangeService() {
        return new JdbcPasswordManagementService((CipherExecutor<Serializable, String>)this.passwordManagementCipherExecutor, this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm(), this.jdbcPasswordManagementDataSource());
    }
}

