/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.jdbc;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;

public class JdbcPasswordManagementService
extends BasePasswordManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcPasswordManagementService.class);
    private final JdbcTemplate jdbcTemplate;

    public JdbcPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordManagementProperties passwordManagementProperties, DataSource dataSource) {
        super(cipherExecutor, issuer, passwordManagementProperties);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public boolean changeInternal(Credential credential, PasswordChangeBean bean) {
        UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
        PasswordEncoder encoder = PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)this.properties.getJdbc().getPasswordEncoder());
        String password = encoder.encode((CharSequence)bean.getPassword());
        int count = this.jdbcTemplate.update(this.properties.getJdbc().getSqlChangePassword(), new Object[]{password, c.getId()});
        return count > 0;
    }

    public String findEmail(String username) {
        try {
            String email = (String)this.jdbcTemplate.queryForObject(this.properties.getJdbc().getSqlFindEmail(), String.class, new Object[]{username});
            if (StringUtils.isNotBlank((CharSequence)email) && EmailValidator.getInstance().isValid(email)) {
                return email;
            }
            LOGGER.debug("Username [{}] not found when searching for email", (Object)username);
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug("Username [{}] not found when searching for email", (Object)username);
            return null;
        }
    }

    public Map<String, String> getSecurityQuestions(String username) {
        String sqlSecurityQuestions = this.properties.getJdbc().getSqlSecurityQuestions();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List results = this.jdbcTemplate.queryForList(sqlSecurityQuestions, new Object[]{username});
        results.forEach(row -> {
            if (row.containsKey("question") && row.containsKey("answer")) {
                map.put(row.get("question").toString(), row.get("answer").toString());
            }
        });
        LOGGER.debug("Found [{}] security questions for [{}]", (Object)map.size(), (Object)username);
        return map;
    }
}

