/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.jdbc;

import java.util.Map;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.jdbc.BaseJdbcPasswordManagementServiceTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.jdbc.core.JdbcTemplate;

@Tag(value="JDBC")
public class JdbcPasswordManagementServiceTests
extends BaseJdbcPasswordManagementServiceTests {
    @Test
    public void verifyUserEmailCanBeFound() {
        String email = this.passwordChangeService.findEmail("casuser");
        Assertions.assertEquals((Object)"casuser@example.org", (Object)email);
    }

    @Test
    public void verifyPhoneNumberCanBeFound() {
        String phone = this.passwordChangeService.findPhone("casuser");
        Assertions.assertEquals((Object)"1234567890", (Object)phone);
    }

    @Test
    public void verifyNullReturnedIfUserEmailCannotBeFound() {
        String email = this.passwordChangeService.findEmail("unknown");
        Assertions.assertNull((Object)email);
    }

    @Test
    public void verifyUserQuestionsCanBeFound() {
        Map questions = this.passwordChangeService.getSecurityQuestions("casuser");
        Assertions.assertEquals((int)2, (int)questions.size());
        Assertions.assertTrue((boolean)questions.containsKey("question1"));
        Assertions.assertTrue((boolean)questions.containsKey("question2"));
    }

    @Test
    public void verifyUserPasswordChange() {
        UsernamePasswordCredential c = new UsernamePasswordCredential("casuser", "password");
        PasswordChangeRequest bean = new PasswordChangeRequest();
        bean.setConfirmedPassword("newPassword1");
        bean.setUsername(c.getUsername());
        bean.setPassword("newPassword1");
        boolean res = this.passwordChangeService.change((Credential)c, bean);
        Assertions.assertTrue((boolean)res);
    }

    @BeforeEach
    public void before() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.jdbcPasswordManagementDataSource);
        this.dropTablesBeforeTest(jdbcTemplate);
        jdbcTemplate.execute("create table pm_table_accounts (id int, userid varchar(255),password varchar(255), email varchar(255), phone varchar(255));");
        jdbcTemplate.execute("insert into pm_table_accounts values (100, 'casuser', 'password', 'casuser@example.org', '1234567890');");
        jdbcTemplate.execute("create table pm_table_questions (id int, userid varchar(255), question varchar(255), answer varchar(255));");
        jdbcTemplate.execute("insert into pm_table_questions values (100, 'casuser', 'question1', 'answer1');");
        jdbcTemplate.execute("insert into pm_table_questions values (200, 'casuser', 'question2', 'answer2');");
    }

    protected void dropTablesBeforeTest(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.execute("drop table pm_table_accounts if exists;");
        jdbcTemplate.execute("drop table pm_table_questions if exists;");
    }
}

