/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.rest;

import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestPasswordManagementService
extends BasePasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestPasswordManagementService.class);
    private final RestTemplate restTemplate;

    public RestPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, RestTemplate restTemplate, PasswordManagementProperties passwordManagementProperties) {
        super(passwordManagementProperties, cipherExecutor, issuer);
        this.restTemplate = restTemplate;
    }

    public boolean changeInternal(Credential c, PasswordChangeBean bean) {
        PasswordManagementProperties.Rest rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlChange())) {
            return false;
        }
        UsernamePasswordCredential upc = (UsernamePasswordCredential)c;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("username", CollectionUtils.wrap((Object)upc.getUsername()));
        headers.put("password", CollectionUtils.wrap((Object)bean.getPassword()));
        headers.put("oldPassword", CollectionUtils.wrap((Object)upc.getPassword()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlChange(), HttpMethod.POST, entity, Boolean.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value()) {
            return (Boolean)result.getBody();
        }
        return false;
    }

    public String findEmail(String username) {
        PasswordManagementProperties.Rest rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlEmail())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("username", CollectionUtils.wrap((Object)username));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlEmail(), HttpMethod.GET, entity, String.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    public Map<String, String> getSecurityQuestions(String username) {
        PasswordManagementProperties.Rest rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlSecurityQuestions())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("username", CollectionUtils.wrap((Object)username));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlSecurityQuestions(), HttpMethod.GET, entity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (Map)result.getBody();
        }
        return null;
    }
}

