/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.pm;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.rest.RestPasswordManagementService;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration(value="restPasswordManagementConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RestPasswordManagementConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="passwordManagementCipherExecutor")
    private ObjectProvider<CipherExecutor> passwordManagementCipherExecutor;
    @Autowired
    @Qualifier(value="passwordHistoryService")
    private ObjectProvider<PasswordHistoryService> passwordHistoryService;

    @RefreshScope
    @Bean
    @Autowired
    public PasswordManagementService passwordChangeService(RestTemplateBuilder restTemplateBuilder) {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        return new RestPasswordManagementService((CipherExecutor<Serializable, String>)((CipherExecutor)this.passwordManagementCipherExecutor.getIfAvailable()), this.casProperties.getServer().getPrefix(), this.buildRestTemplateBuilder(restTemplateBuilder), pm, (PasswordHistoryService)this.passwordHistoryService.getIfAvailable());
    }

    private RestTemplate buildRestTemplateBuilder(RestTemplateBuilder restTemplateBuilder) {
        PasswordManagementProperties.Rest pmRest = this.casProperties.getAuthn().getPm().getRest();
        String username = pmRest.getEndpointUsername();
        String password = pmRest.getEndpointPassword();
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            return restTemplateBuilder.basicAuthentication(username, password).build();
        }
        return restTemplateBuilder.build();
    }
}

