/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.rest;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.model.support.pm.RestfulPasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestPasswordManagementService
extends BasePasswordManagementService {
    private final RestTemplate restTemplate;

    public RestPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, RestTemplate restTemplate, PasswordManagementProperties passwordManagementProperties, PasswordHistoryService passwordHistoryService) {
        super(passwordManagementProperties, cipherExecutor, issuer, passwordHistoryService);
        this.restTemplate = restTemplate;
    }

    public boolean changeInternal(Credential c, PasswordChangeRequest bean) {
        RestfulPasswordManagementProperties rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlChange())) {
            return false;
        }
        UsernamePasswordCredential upc = (UsernamePasswordCredential)c;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("username", CollectionUtils.wrap((Object)upc.getUsername()));
        headers.put("password", CollectionUtils.wrap((Object)bean.getPassword()));
        headers.put("oldPassword", CollectionUtils.wrap((Object)upc.getPassword()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlChange(), HttpMethod.POST, entity, Boolean.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return Objects.requireNonNull((Boolean)result.getBody());
        }
        return false;
    }

    public String findUsername(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlUser())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("email", CollectionUtils.wrap((Object)query.getUsername()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlUser(), HttpMethod.GET, entity, String.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    public String findEmail(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlEmail())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("username", CollectionUtils.wrap((Object)query.getUsername()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlEmail(), HttpMethod.GET, entity, String.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    public String findPhone(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlPhone())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("username", CollectionUtils.wrap((Object)query.getUsername()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlPhone(), HttpMethod.GET, entity, String.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.properties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlSecurityQuestions())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
        headers.put("username", CollectionUtils.wrap((Object)query.getUsername()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlSecurityQuestions(), HttpMethod.GET, entity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (Map)result.getBody();
        }
        return null;
    }
}

