/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.rest;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.config.CasCoreAuditConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreTicketsSerializationConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.PasswordManagementConfiguration;
import org.apereo.cas.config.RestPasswordManagementConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.RestfulPasswordManagementProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.rest.RestPasswordManagementService;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestTemplate;

@Tag(value="RestfulApi")
class RestPasswordManagementServiceTests {
    RestPasswordManagementServiceTests() {
    }

    @Nested
    @SpringBootTest(classes={SharedTestConfiguration.class}, properties={"cas.authn.pm.rest.endpoint-url-change=http://localhost:9090", "cas.authn.pm.rest.endpoint-url-security-questions=http://localhost:9090", "cas.authn.pm.rest.endpoint-url-email=http://localhost:9091", "cas.authn.pm.rest.endpoint-url-user=http://localhost:9090", "cas.authn.pm.rest.endpoint-url-phone=http://localhost:9092", "cas.authn.pm.rest.endpoint-url-account-unlock=http://localhost:9092", "cas.authn.pm.rest.endpoint-username=username", "cas.authn.pm.rest.endpoint-password=password"})
    public class BasicOperations {
        @Autowired
        @Qualifier(value="passwordChangeService")
        private PasswordManagementService passwordChangeService;
        @Autowired
        @Qualifier(value="passwordManagementCipherExecutor")
        private CipherExecutor passwordManagementCipherExecutor;
        @Autowired
        @Qualifier(value="passwordHistoryService")
        private PasswordHistoryService passwordHistoryService;

        public BasicOperations(RestPasswordManagementServiceTests this$0) {
        }

        @Test
        void verifyEmailFound() throws Throwable {
            String data = "casuser@example.org";
            try (MockWebServer webServer = new MockWebServer(9091, (Resource)new ByteArrayResource("casuser@example.org".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
                webServer.start();
                String email = this.passwordChangeService.findEmail(PasswordManagementQuery.builder().username("casuser").build());
                webServer.stop();
                Assertions.assertNotNull((Object)email);
                Assertions.assertEquals((Object)"casuser@example.org", (Object)email);
            }
            webServer = new MockWebServer(9091, HttpStatus.NO_CONTENT);
            try {
                webServer.start();
                Assertions.assertNull((Object)this.passwordChangeService.findEmail(PasswordManagementQuery.builder().username("casuser").build()));
                webServer.stop();
            }
            finally {
                webServer.close();
            }
        }

        @Test
        void verifyUserFound() throws Throwable {
            String data = "casuser";
            try (MockWebServer webServer = new MockWebServer(9090, (Resource)new ByteArrayResource("casuser".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
                webServer.start();
                String username = this.passwordChangeService.findUsername(PasswordManagementQuery.builder().email("casuser@example.org").build());
                webServer.stop();
                Assertions.assertNotNull((Object)username);
                Assertions.assertEquals((Object)"casuser", (Object)username);
            }
            webServer = new MockWebServer(9090, HttpStatus.NO_CONTENT);
            try {
                webServer.start();
                Assertions.assertNull((Object)this.passwordChangeService.findUsername(PasswordManagementQuery.builder().username("casuser").build()));
                webServer.stop();
            }
            finally {
                webServer.close();
            }
        }

        @Test
        void verifyPhoneFound() throws Throwable {
            String data = "1234567890";
            try (MockWebServer webServer = new MockWebServer(9092, (Resource)new ByteArrayResource("1234567890".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
                webServer.start();
                String ph = this.passwordChangeService.findPhone(PasswordManagementQuery.builder().username("casuser").build());
                webServer.stop();
                Assertions.assertNotNull((Object)ph);
                Assertions.assertEquals((Object)"1234567890", (Object)ph);
            }
            webServer = new MockWebServer(9092, HttpStatus.NO_CONTENT);
            try {
                webServer.start();
                Assertions.assertNull((Object)this.passwordChangeService.findPhone(PasswordManagementQuery.builder().username("casuser").build()));
                webServer.stop();
            }
            finally {
                webServer.close();
            }
        }

        @Test
        void verifySecurityQuestions() throws Throwable {
            String data = "{\"question1\":\"answer1\"}";
            try (MockWebServer webServer = new MockWebServer(9308, (Resource)new ByteArrayResource("{\"question1\":\"answer1\"}".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
                webServer.start();
                CasConfigurationProperties props = new CasConfigurationProperties();
                RestfulPasswordManagementProperties rest = props.getAuthn().getPm().getRest();
                rest.setEndpointUrlChange("http://localhost:9308");
                rest.setEndpointUrlSecurityQuestions("http://localhost:9308");
                rest.setEndpointUrlEmail("http://localhost:9308");
                RestPasswordManagementService passwordService = this.getRestPasswordManagementService(props);
                Map questions = passwordService.getSecurityQuestions(PasswordManagementQuery.builder().username("casuser").build());
                Assertions.assertFalse((boolean)questions.isEmpty());
                Assertions.assertTrue((boolean)questions.containsKey("question1"));
                webServer.stop();
            }
            webServer = new MockWebServer(9090, HttpStatus.NO_CONTENT);
            try {
                webServer.start();
                Assertions.assertNull((Object)this.passwordChangeService.getSecurityQuestions(PasswordManagementQuery.builder().username("casuser").build()));
                webServer.stop();
            }
            finally {
                webServer.close();
            }
        }

        @Test
        void verifyUpdateSecurityQuestions() throws Throwable {
            PasswordManagementQuery query = PasswordManagementQuery.builder().username("casuser").build();
            query.securityQuestion("Q1", "A1");
            try (MockWebServer webServer = new MockWebServer(9308, HttpStatus.OK);){
                webServer.start();
                CasConfigurationProperties props = new CasConfigurationProperties();
                RestfulPasswordManagementProperties rest = props.getAuthn().getPm().getRest();
                rest.setEndpointUrlChange("http://localhost:9308");
                rest.setEndpointUrlSecurityQuestions("http://localhost:9308");
                rest.setEndpointUrlEmail("http://localhost:9308");
                RestPasswordManagementService passwordService = this.getRestPasswordManagementService(props);
                Assertions.assertDoesNotThrow(() -> passwordService.updateSecurityQuestions(query));
            }
        }

        private RestPasswordManagementService getRestPasswordManagementService(CasConfigurationProperties props) {
            return new RestPasswordManagementService(this.passwordManagementCipherExecutor, props.getServer().getPrefix(), new RestTemplate(), props.getAuthn().getPm(), this.passwordHistoryService);
        }

        @Test
        void verifyUnlockAccount() throws Throwable {
            try (MockWebServer webServer = new MockWebServer(9308, HttpStatus.OK);){
                webServer.start();
                CasConfigurationProperties props = new CasConfigurationProperties();
                RestfulPasswordManagementProperties rest = props.getAuthn().getPm().getRest();
                rest.setEndpointUrlAccountUnlock("http://localhost:9308");
                RestPasswordManagementService passwordService = this.getRestPasswordManagementService(props);
                Assertions.assertDoesNotThrow(() -> passwordService.unlockAccount((Credential)CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword()));
            }
        }

        @Test
        void verifyPasswordChanged() throws Throwable {
            String data = "true";
            PasswordChangeRequest request = new PasswordChangeRequest("casuser", "current-psw".toCharArray(), "123456".toCharArray(), "123456".toCharArray());
            try (MockWebServer webServer = new MockWebServer(9309, (Resource)new ByteArrayResource("true".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
                webServer.start();
                CasConfigurationProperties props = new CasConfigurationProperties();
                RestfulPasswordManagementProperties rest = props.getAuthn().getPm().getRest();
                rest.setEndpointUrlChange("http://localhost:9309");
                rest.setEndpointUrlSecurityQuestions("http://localhost:9309");
                rest.setEndpointUrlEmail("http://localhost:9309");
                RestPasswordManagementService passwordService = this.getRestPasswordManagementService(props);
                boolean result = passwordService.change(request);
                Assertions.assertTrue((boolean)result);
                webServer.stop();
            }
            webServer = new MockWebServer(9090, HttpStatus.NO_CONTENT);
            try {
                webServer.start();
                boolean result = this.passwordChangeService.change(request);
                Assertions.assertFalse((boolean)result);
                webServer.stop();
            }
            finally {
                webServer.close();
            }
        }
    }

    @Nested
    @SpringBootTest(classes={SharedTestConfiguration.class})
    public class UndefinedConfigurationOperations {
        @Autowired
        @Qualifier(value="passwordChangeService")
        private PasswordManagementService passwordChangeService;

        public UndefinedConfigurationOperations(RestPasswordManagementServiceTests this$0) {
        }

        @Test
        void verifyEmailFound() throws Throwable {
            PasswordChangeRequest request = new PasswordChangeRequest("casuser", "current-psw".toCharArray(), "123456".toCharArray(), "123456".toCharArray());
            Assertions.assertFalse((boolean)this.passwordChangeService.change(request));
            Assertions.assertNull((Object)this.passwordChangeService.findEmail(PasswordManagementQuery.builder().username("casuser").build()));
            Assertions.assertNull((Object)this.passwordChangeService.findUsername(PasswordManagementQuery.builder().username("casuser").build()));
            Assertions.assertNull((Object)this.passwordChangeService.findPhone(PasswordManagementQuery.builder().username("casuser").build()));
            Assertions.assertNull((Object)this.passwordChangeService.getSecurityQuestions(PasswordManagementQuery.builder().username("casuser").build()));
            Assertions.assertTrue((boolean)this.passwordChangeService.unlockAccount((Credential)CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword((String)"casuser")));
        }
    }

    @ImportAutoConfiguration(value={MailSenderAutoConfiguration.class, AopAutoConfiguration.class, WebMvcAutoConfiguration.class, RefreshAutoConfiguration.class})
    @SpringBootConfiguration
    @Import(value={RestPasswordManagementConfiguration.class, PasswordManagementConfiguration.class, RestTemplateAutoConfiguration.class, CasCoreConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketsSerializationConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreServicesConfiguration.class, CasCoreWebConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreAuditConfiguration.class, CasCoreUtilConfiguration.class})
    static class SharedTestConfiguration {
        SharedTestConfiguration() {
        }
    }
}

