/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowConfigurer;
import org.apereo.cas.pm.web.flow.actions.HandlePasswordExpirationWarningMessagesAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordResetAction;
import org.apereo.cas.pm.web.flow.actions.PasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.SendPasswordResetInstructionsAction;
import org.apereo.cas.pm.web.flow.actions.VerifyPasswordResetRequestAction;
import org.apereo.cas.pm.web.flow.actions.VerifySecurityQuestionsAction;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.StaticEventExecutionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

@Configuration(value="passwordManagementWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementWebflowConfiguration
implements CasWebflowExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementWebflowConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="communicationsManager")
    private CommunicationsManager communicationsManager;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="loginFlowExecutor")
    private FlowExecutor loginFlowExecutor;
    @Autowired
    @Qualifier(value="passwordValidationService")
    private PasswordValidationService passwordValidationService;
    @Autowired
    @Qualifier(value="passwordChangeService")
    private PasswordManagementService passwordManagementService;

    @RefreshScope
    @Bean
    public HandlerAdapter passwordResetHandlerAdapter() {
        FlowHandlerAdapter handler = new FlowHandlerAdapter(){

            public boolean supports(Object handler) {
                return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("pswdreset");
            }
        };
        handler.setFlowExecutor(this.loginFlowExecutor);
        return handler;
    }

    @ConditionalOnMissingBean(name={"initPasswordChangeAction"})
    @RefreshScope
    @Bean
    public Action initPasswordChangeAction() {
        return new InitPasswordChangeAction(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"initPasswordResetAction"})
    @RefreshScope
    @Bean
    public Action initPasswordResetAction() {
        return new InitPasswordResetAction(this.passwordManagementService);
    }

    @ConditionalOnMissingBean(name={"passwordChangeAction"})
    @RefreshScope
    @Bean
    public Action passwordChangeAction() {
        return new PasswordChangeAction(this.passwordManagementService, this.passwordValidationService);
    }

    @ConditionalOnMissingBean(name={"sendPasswordResetInstructionsAction"})
    @Bean
    @RefreshScope
    public Action sendPasswordResetInstructionsAction() {
        return new SendPasswordResetInstructionsAction(this.casProperties, this.communicationsManager, this.passwordManagementService);
    }

    @ConditionalOnMissingBean(name={"verifyPasswordResetRequestAction"})
    @Bean
    @RefreshScope
    public Action verifyPasswordResetRequestAction() {
        return new VerifyPasswordResetRequestAction(this.casProperties, this.passwordManagementService);
    }

    @ConditionalOnMissingBean(name={"handlePasswordExpirationWarningMessagesAction"})
    @Bean
    @RefreshScope
    public Action handlePasswordExpirationWarningMessagesAction() {
        return new HandlePasswordExpirationWarningMessagesAction();
    }

    @ConditionalOnMissingBean(name={"verifySecurityQuestionsAction"})
    @Bean
    @RefreshScope
    public Action verifySecurityQuestionsAction() {
        if (!this.casProperties.getAuthn().getPm().getReset().isSecurityQuestionsEnabled()) {
            LOGGER.debug("Functionality to handle security questions for password management is not enabled");
            return new StaticEventExecutionAction("success");
        }
        return new VerifySecurityQuestionsAction(this.passwordManagementService);
    }

    @ConditionalOnMissingBean(name={"passwordManagementWebflowConfigurer"})
    @RefreshScope
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer passwordManagementWebflowConfigurer() {
        return new PasswordManagementWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.applicationContext, this.casProperties, this.initPasswordChangeAction());
    }

    public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
        plan.registerWebflowConfigurer(this.passwordManagementWebflowConfigurer());
    }
}

