/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class PasswordManagementWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementWebflowConfigurer.class);
    public static final String FLOW_ID_PASSWORD_RESET = "pswdreset";
    public static final String FLOW_VAR_ID_PASSWORD = "password";
    public static final String DO_CHANGE_PASSWORD_PARAMETER = "doChangePassword";
    private static final String PASSWORD_CHANGE_ACTION = "passwordChangeAction";
    private static final String SEND_PASSWORD_RESET_INSTRUCTIONS_ACTION = "sendInstructions";
    private final Action initPasswordChangeAction;

    public PasswordManagementWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties, Action initPasswordChangeAction) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.initPasswordChangeAction = initPasswordChangeAction;
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createAccountStatusViewStates(flow);
        }
    }

    private void createAccountStatusViewStates(Flow flow) {
        this.createViewState(flow, "casAuthenticationBlockedView", "casAuthenticationBlockedView");
        this.createViewState(flow, "casBadWorkstationView", "casBadWorkstationView");
        this.createViewState(flow, "casBadHoursView", "casBadHoursView");
        this.createViewState(flow, "casAccountLockedView", "casAccountLockedView");
        this.createViewState(flow, "casAccountDisabledView", "casAccountDisabledView");
        this.createViewState(flow, "casPasswordUpdateSuccess", "casPasswordUpdateSuccessView");
        if (this.casProperties.getAuthn().getPm().isEnabled()) {
            this.configurePasswordResetFlow(flow, "casExpiredPassView");
            this.configurePasswordResetFlow(flow, "casMustChangePassView");
            this.configurePasswordMustChangeForAuthnWarnings(flow);
            this.configurePasswordExpirationWarning(flow);
            this.createPasswordResetFlow();
        } else {
            this.createViewState(flow, "casExpiredPassView", "casExpiredPassView");
            this.createViewState(flow, "casMustChangePassView", "casMustChangePassView");
        }
    }

    private void configurePasswordExpirationWarning(Flow flow) {
        TransitionableState warningState = this.getTransitionableState(flow, "showAuthenticationWarningMessages");
        warningState.getEntryActionList().add((Action)this.createEvaluateAction("handlePasswordExpirationWarningMessagesAction"));
    }

    private void configurePasswordMustChangeForAuthnWarnings(Flow flow) {
        TransitionableState warningState = this.getTransitionableState(flow, "showAuthenticationWarningMessages");
        warningState.getEntryActionList().add((Action)this.createEvaluateAction("flowScope.pswdChangePostLogin=true"));
        this.createTransitionForState(warningState, "changePassword", "casMustChangePassView");
    }

    private void createPasswordResetFlow() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            boolean autoLogin = this.casProperties.getAuthn().getPm().isAutoLogin();
            ViewState state = (ViewState)this.getState(flow, "viewLoginForm", ViewState.class);
            this.createTransitionForState((TransitionableState)state, "resetPassword", "casResetPasswordSendInstructionsView");
            ViewState accountInfo = this.createViewState(flow, "casResetPasswordSendInstructionsView", "casResetPasswordSendInstructionsView");
            this.createTransitionForState((TransitionableState)accountInfo, "findAccount", SEND_PASSWORD_RESET_INSTRUCTIONS_ACTION);
            ActionState sendInst = this.createActionState(flow, SEND_PASSWORD_RESET_INSTRUCTIONS_ACTION, (Action)this.createEvaluateAction("sendPasswordResetInstructionsAction"));
            this.createTransitionForState((TransitionableState)sendInst, "success", "casResetPasswordSentInstructionsView");
            this.createTransitionForState((TransitionableState)sendInst, "error", accountInfo.getId());
            this.createViewState(flow, "casResetPasswordSentInstructionsView", "casResetPasswordSentInstructionsView");
            Flow pswdFlow = this.buildFlow("classpath:/webflow/pswdreset/pswdreset-webflow.xml", FLOW_ID_PASSWORD_RESET);
            this.createViewState(pswdFlow, "passwordResetErrorView", "casResetPasswordErrorView");
            this.createViewState(pswdFlow, "casPasswordUpdateSuccess", "casPasswordUpdateSuccessView");
            this.configurePasswordResetFlow(pswdFlow, "casMustChangePassView");
            this.loginFlowDefinitionRegistry.registerFlowDefinition((FlowDefinition)pswdFlow);
            ActionState initializeLoginFormState = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
            String originalTargetState = initializeLoginFormState.getTransition("success").getTargetStateId();
            SubflowState pswdResetSubFlowState = this.createSubflowState(flow, "pswdResetSubflow", FLOW_ID_PASSWORD_RESET);
            this.getTransitionableState(flow, "createTicketGrantingTicket").getEntryActionList().add((Action)this.createEvaluateAction("flowScope.doChangePassword = requestParameters.doChangePassword != null"));
            this.createDecisionState(flow, "checkForPswdResetToken", "requestParameters.pswdrst != null", "pswdResetSubflow", originalTargetState);
            this.createTransitionForState((TransitionableState)initializeLoginFormState, "success", "checkForPswdResetToken", true);
            this.createEndState(pswdFlow, "pswdResetComplete");
            this.createTransitionForState(this.getTransitionableState(pswdFlow, "casPasswordUpdateSuccess"), "proceed", "pswdResetComplete");
            this.createEndState(flow, "redirectToLogin", "'login'", true);
            this.createTransitionForState((TransitionableState)pswdResetSubFlowState, "pswdResetComplete", autoLogin ? "realSubmit" : "redirectToLogin");
            this.createDecisionState(flow, "checkDoChangePassword", "flowScope.doChangePassword == true", "casMustChangePassView", this.getTransitionableState(flow, "createTicketGrantingTicket").getTransition("success").getTargetStateId()).getEntryActionList().add((Action)this.createEvaluateAction("flowScope.pswdChangePostLogin=true"));
            this.createTransitionForState(this.getTransitionableState(flow, "createTicketGrantingTicket"), "success", "checkDoChangePassword", true);
            this.createDecisionState(flow, "postLoginPswdChangeCheck", "flowScope.pswdChangePostLogin == true", this.getTransitionableState(flow, "showAuthenticationWarningMessages").getTransition("proceed").getTargetStateId(), autoLogin ? "realSubmit" : "redirectToLogin");
            this.createTransitionForState(this.getTransitionableState(flow, "casPasswordUpdateSuccess"), "proceed", "postLoginPswdChangeCheck");
        }
    }

    private void configurePasswordResetFlow(Flow flow, String id) {
        this.createFlowVariable(flow, FLOW_VAR_ID_PASSWORD, PasswordChangeBean.class);
        BinderConfiguration binder = this.createStateBinderConfiguration(CollectionUtils.wrapList((Object[])new String[]{FLOW_VAR_ID_PASSWORD, "confirmedPassword"}));
        ViewState viewState = this.createViewState(flow, id, id, binder);
        this.createStateModelBinding((TransitionableState)viewState, FLOW_VAR_ID_PASSWORD, PasswordChangeBean.class);
        viewState.getEntryActionList().add(this.initPasswordChangeAction);
        Transition transition = this.createTransitionForState((TransitionableState)viewState, "submit", PASSWORD_CHANGE_ACTION);
        transition.getAttributes().put("bind", (Object)Boolean.TRUE);
        transition.getAttributes().put("validate", (Object)Boolean.TRUE);
        this.createStateDefaultTransition((TransitionableState)viewState, id);
        ActionState pswChangeAction = this.createActionState(flow, PASSWORD_CHANGE_ACTION, (Action)this.createEvaluateAction(PASSWORD_CHANGE_ACTION));
        TransitionSet transitionSet = pswChangeAction.getTransitionSet();
        transitionSet.add(this.createTransition("passwordUpdateSuccess", "casPasswordUpdateSuccess"));
        transitionSet.add(this.createTransition("error", id));
    }
}

