/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.apereo.cas.pm.config.PasswordManagementWebflowConfiguration;
import org.apereo.cas.web.flow.BaseWebflowConfigurerTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;

@Import(value={PasswordManagementConfiguration.class, PasswordManagementWebflowConfiguration.class, BaseWebflowConfigurerTests.SharedTestConfiguration.class})
@TestPropertySource(properties={"cas.authn.pm.enabled=false"})
@Tag(value="Webflow")
public class PasswordManagementWebflowConfigurerDisabledTests
extends BaseWebflowConfigurerTests {
    @Test
    public void verifyOperation() {
        Assertions.assertFalse((boolean)this.casWebflowExecutionPlan.getWebflowConfigurers().isEmpty());
        Flow flow = (Flow)this.loginFlowDefinitionRegistry.getFlowDefinition("login");
        Assertions.assertNotNull((Object)flow);
        TransitionableState state = (TransitionableState)flow.getState("casAuthenticationBlockedView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casBadWorkstationView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casBadHoursView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casAccountLockedView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casAccountDisabledView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casPasswordUpdateSuccess");
        Assertions.assertNotNull((Object)state);
        this.verifyPasswordManagementStates(flow);
    }

    protected void verifyPasswordManagementStates(Flow flow) {
        TransitionableState state = (TransitionableState)flow.getState("casExpiredPassView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casMustChangePassView");
        Assertions.assertNotNull((Object)state);
    }
}

