/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@EnabledIfPortOpen(port={25000})
@Tag(value="Mail")
public class InitPasswordResetActionTests
extends BasePasswordManagementActionTests {
    @Test
    public void verifyAction() {
        try {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setRemoteAddr("1.2.3.4");
            request.setLocalAddr("1.2.3.4");
            ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
            String token = this.passwordManagementService.createToken("casuser");
            MockRequestContext context = new MockRequestContext();
            context.getFlowScope().put("token", (Object)token);
            context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
            Assertions.assertEquals((Object)"success", (Object)this.initPasswordResetAction.execute((RequestContext)context).getId());
            UsernamePasswordCredential c = (UsernamePasswordCredential)WebUtils.getCredential((RequestContext)context, UsernamePasswordCredential.class);
            Assertions.assertNotNull((Object)c);
            Assertions.assertEquals((Object)"casuser", (Object)c.getUsername());
        }
        catch (Exception e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }
}

