/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@EnabledIfPortOpen(port={25000})
@Tag(value="Mail")
public class VerifyPasswordResetRequestActionTests
extends BasePasswordManagementActionTests {
    @Test
    public void verifyInvalidToken() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        request.addParameter("pswdrst", UUID.randomUUID().toString());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.verifyPasswordResetRequestAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyAction() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.verifyPasswordResetRequestAction.execute((RequestContext)context).getId());
        request.setRemoteAddr("1.2.3.4");
        request.setLocalAddr("1.2.3.4");
        request.addHeader("user-agent", (Object)"test");
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
        String token = this.passwordManagementService.createToken("casuser");
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
        String serverPrefix = this.casProperties.getServer().getPrefix();
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(serverPrefix);
        Map properties = CollectionUtils.wrap((String)"token", (Object)token);
        TransientSessionTicket ticket = transientFactory.create((Service)service, properties);
        this.ticketRegistry.addTicket((Ticket)ticket);
        request.addParameter("pswdrst", ticket.getId());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"success", (Object)this.verifyPasswordResetRequestAction.execute((RequestContext)context).getId());
        Assertions.assertTrue((boolean)PasswordManagementWebflowUtils.isPasswordResetSecurityQuestionsEnabled((RequestContext)context));
        Assertions.assertNotNull((Object)PasswordManagementWebflowUtils.getPasswordResetUsername((RequestContext)context));
        Assertions.assertNotNull((Object)PasswordManagementWebflowUtils.getPasswordResetToken((RequestContext)context));
    }

    @Test
    public void verifyNoQuestionsAvailAction() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("1.2.3.4");
        request.setLocalAddr("1.2.3.4");
        request.addHeader("user-agent", (Object)"test");
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        String token = this.passwordManagementService.createToken("noquestions");
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
        String serverPrefix = this.casProperties.getServer().getPrefix();
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(serverPrefix);
        Map properties = CollectionUtils.wrap((String)"token", (Object)token);
        TransientSessionTicket ticket = transientFactory.create((Service)service, properties);
        this.ticketRegistry.addTicket((Ticket)ticket);
        request.addParameter("pswdrst", ticket.getId());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.verifyPasswordResetRequestAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyBadTicketAction() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("pswdrst", "badticket");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.verifyPasswordResetRequestAction.execute((RequestContext)context).getId());
    }
}

