/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.apereo.cas.pm.config.PasswordManagementForgotUsernameConfiguration;
import org.apereo.cas.pm.config.PasswordManagementWebflowConfiguration;
import org.apereo.cas.web.flow.BaseWebflowConfigurerTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.test.MockRequestContext;

@Import(value={PasswordManagementConfiguration.class, PasswordManagementWebflowConfiguration.class, PasswordManagementForgotUsernameConfiguration.class, BaseWebflowConfigurerTests.SharedTestConfiguration.class})
@TestPropertySource(properties={"cas.authn.pm.reset.security-questions-enabled=false", "cas.authn.pm.core.enabled=false"})
@Tag(value="WebflowConfig")
public class PasswordManagementWebflowConfigurerDisabledTests
extends BaseWebflowConfigurerTests {
    @Autowired
    @Qualifier(value="passwordResetHandlerAdapter")
    private HandlerAdapter passwordResetHandlerAdapter;
    @Autowired
    @Qualifier(value="verifySecurityQuestionsAction")
    private Action verifySecurityQuestionsAction;

    @Test
    public void verifyOperation() throws Exception {
        Assertions.assertFalse((boolean)this.casWebflowExecutionPlan.getWebflowConfigurers().isEmpty());
        Flow flow = (Flow)this.loginFlowDefinitionRegistry.getFlowDefinition("login");
        Assertions.assertNotNull((Object)flow);
        TransitionableState state = (TransitionableState)flow.getState("casAuthenticationBlockedView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casBadWorkstationView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casBadHoursView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casAccountLockedView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casAccountDisabledView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casPasswordUpdateSuccess");
        Assertions.assertNotNull((Object)state);
        FlowHandler handler = (FlowHandler)Mockito.mock(FlowHandler.class);
        Mockito.when((Object)handler.getFlowId()).thenReturn((Object)"pswdreset");
        Assertions.assertTrue((boolean)this.passwordResetHandlerAdapter.supports((Object)handler));
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        Assertions.assertEquals((Object)"success", (Object)this.verifySecurityQuestionsAction.execute((RequestContext)context).getId());
        this.verifyPasswordManagementStates(flow);
    }

    protected void verifyPasswordManagementStates(Flow flow) {
        TransitionableState state = (TransitionableState)flow.getState("casExpiredPassView");
        Assertions.assertNotNull((Object)state);
        state = (TransitionableState)flow.getState("casMustChangePassView");
        Assertions.assertNotNull((Object)state);
    }
}

