/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowActions")
@TestPropertySource(properties={"cas.authn.pm.core.policy-pattern=P@ss.+"})
public class PasswordChangeActionTests
extends BasePasswordManagementActionTests {
    @Autowired
    @Qualifier(value="passwordChangeAction")
    private Action passwordChangeAction;

    @Test
    public void verifyFailNoCreds() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        PasswordChangeRequest changeReq = new PasswordChangeRequest();
        changeReq.setUsername("casuser");
        changeReq.setPassword("123456");
        context.getFlowScope().put("password", (Object)changeReq);
        Assertions.assertEquals((Object)"error", (Object)this.passwordChangeAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyFailsValidation() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        WebUtils.putCredential((RequestContext)context, (Credential)RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword((String)"casuser"));
        PasswordChangeRequest changeReq = new PasswordChangeRequest();
        changeReq.setUsername("casuser");
        changeReq.setPassword("123456");
        context.getFlowScope().put("password", (Object)changeReq);
        Assertions.assertEquals((Object)"error", (Object)this.passwordChangeAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyChange() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        WebUtils.putCredential((RequestContext)context, (Credential)RegisteredServiceTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"casuser", (String)"Th!$isT3$t"));
        PasswordChangeRequest changeReq = new PasswordChangeRequest();
        changeReq.setUsername("casuser");
        changeReq.setPassword("P@ssword");
        changeReq.setConfirmedPassword("P@ssword");
        context.getFlowScope().put("password", (Object)changeReq);
        Assertions.assertEquals((Object)"passwordUpdateSuccess", (Object)this.passwordChangeAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyChangeFails() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        WebUtils.putCredential((RequestContext)context, (Credential)RegisteredServiceTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"bad-credential", (String)"P@ssword"));
        PasswordChangeRequest changeReq = new PasswordChangeRequest();
        changeReq.setUsername("bad-credential");
        changeReq.setPassword("P@ssword");
        changeReq.setConfirmedPassword("P@ssword");
        context.getFlowScope().put("password", (Object)changeReq);
        Assertions.assertEquals((Object)"error", (Object)this.passwordChangeAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyPasswordRejected() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        WebUtils.putCredential((RequestContext)context, (Credential)RegisteredServiceTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"error-credential", (String)"P@ssword"));
        PasswordChangeRequest changeReq = new PasswordChangeRequest();
        changeReq.setUsername("error-credential");
        changeReq.setPassword("P@ssword");
        changeReq.setConfirmedPassword("P@ssword");
        context.getFlowScope().put("password", (Object)changeReq);
        Assertions.assertEquals((Object)"error", (Object)this.passwordChangeAction.execute((RequestContext)context).getId());
    }
}

