/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@EnabledIfPortOpen(port={25000})
@Tag(value="Mail")
public class SendPasswordResetInstructionsActionTests
extends BasePasswordManagementActionTests {
    @Test
    public void verifyAction() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("username", "casuser");
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"success", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyNoLinkAction() throws Exception {
        ClientInfo clientInfo = (ClientInfo)Mockito.mock(ClientInfo.class);
        Mockito.when((Object)clientInfo.getClientIpAddress()).thenThrow(new Throwable[]{new RuntimeException()});
        ClientInfoHolder.setClientInfo((ClientInfo)clientInfo);
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("username", "casuser");
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyNoPhoneOrEmail() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("username", "none");
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyNoUsername() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
    }
}

