/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="Webflow")
public class PasswordManagementSingleSignOnParticipationStrategyTests
extends BasePasswordManagementActionTests {
    @Autowired
    @Qualifier(value="passwordManagementSingleSignOnParticipationStrategy")
    private SingleSignOnParticipationStrategy strategy;

    @Test
    public void verifyStrategyWithANonPmRequest() {
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().httpServletRequest((HttpServletRequest)new MockHttpServletRequest()).httpServletResponse((HttpServletResponse)new MockHttpServletResponse()).requestContext((RequestContext)new MockRequestContext()).build();
        Assertions.assertFalse((boolean)this.strategy.supports(ssoRequest));
    }

    @Test
    public void verifyStrategyWithAnInvalidPmRequest() {
        MockRequestContext ctx = new MockRequestContext();
        ctx.putRequestParameter("pswdrst", "invalidResetToken");
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().httpServletRequest((HttpServletRequest)new MockHttpServletRequest()).httpServletResponse((HttpServletResponse)new MockHttpServletResponse()).requestContext((RequestContext)ctx).build();
        Assertions.assertTrue((boolean)this.strategy.isParticipating(ssoRequest));
    }

    @Test
    public void verifyStrategyWithAValidPmRequest() throws Exception {
        MockRequestContext ctx = new MockRequestContext();
        String token = this.passwordManagementService.createToken(PasswordManagementQuery.builder().username("casuser").build());
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
        String serverPrefix = this.casProperties.getServer().getPrefix();
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(serverPrefix);
        Map properties = CollectionUtils.wrap((String)"token", (Object)token);
        TransientSessionTicket ticket = transientFactory.create((Service)service, properties);
        this.ticketRegistry.addTicket((Ticket)ticket);
        ctx.putRequestParameter("pswdrst", ticket.getId());
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().httpServletRequest((HttpServletRequest)new MockHttpServletRequest()).httpServletResponse((HttpServletResponse)new MockHttpServletResponse()).requestContext((RequestContext)ctx).build();
        Assertions.assertFalse((boolean)this.strategy.isParticipating(ssoRequest));
    }
}

