/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.ServiceTicketGeneratorAuthority;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.flow.config.CasWebflowAccountProfileConfiguration;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowActions")
@TestPropertySource(properties={"cas.authn.pm.groovy.location=classpath:PasswordManagementService.groovy", "cas.authn.pm.core.enabled=true", "cas.authn.pm.reset.security-questions-enabled=true", "CasFeatureModule.AccountManagement.enabled=true"})
@Import(value={CasWebflowAccountProfileConfiguration.class})
public class AccountProfilePreparePasswordManagementActionTests
extends BasePasswordManagementActionTests {
    @Autowired
    @Qualifier(value="prepareAccountProfilePasswordMgmtAction")
    private Action prepareAccountProfilePasswordMgmtAction;
    @Autowired
    @Qualifier(value="accountProfileServiceTicketGeneratorAuthority")
    private ServiceTicketGeneratorAuthority accountProfileServiceTicketGeneratorAuthority;

    @Test
    public void verifyOperation() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
        WebUtils.putTicketGrantingTicket((RequestContext)context, (TicketGrantingTicket)tgt);
        this.ticketRegistry.addTicket((Ticket)tgt);
        Event result = this.prepareAccountProfilePasswordMgmtAction.execute((RequestContext)context);
        Assertions.assertNull((Object)result);
        Assertions.assertTrue((boolean)WebUtils.isPasswordManagementEnabled((RequestContext)context));
        Assertions.assertNotNull((Object)PasswordManagementWebflowUtils.getPasswordResetQuestions((RequestContext)context, Map.class));
        Assertions.assertEquals((int)0, (int)this.accountProfileServiceTicketGeneratorAuthority.getOrder());
        Assertions.assertFalse((boolean)this.accountProfileServiceTicketGeneratorAuthority.shouldGenerate((AuthenticationResult)Mockito.mock(AuthenticationResult.class), (Service)Mockito.mock(Service.class)));
        String url = StringUtils.appendIfMissing((String)this.casProperties.getServer().getPrefix(), (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("account");
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)url);
        Assertions.assertTrue((boolean)this.accountProfileServiceTicketGeneratorAuthority.supports((AuthenticationResult)Mockito.mock(AuthenticationResult.class), (Service)service));
    }
}

