/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="Mail")
public class InitPasswordResetActionTests
extends BasePasswordManagementActionTests {
    @Test
    public void verifyAction() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("1.2.3.4");
        request.setLocalAddr("1.2.3.4");
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
        String token = this.passwordManagementService.createToken(PasswordManagementQuery.builder().username("casuser").build());
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"error", (Object)this.initPasswordResetAction.execute((RequestContext)context).getId());
        context.getFlowScope().put("token", (Object)token);
        Assertions.assertEquals((Object)"success", (Object)this.initPasswordResetAction.execute((RequestContext)context).getId());
        UsernamePasswordCredential c = (UsernamePasswordCredential)WebUtils.getCredential((RequestContext)context, UsernamePasswordCredential.class);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((Object)"casuser", (Object)c.getUsername());
    }

    @Test
    public void verifyActionUserlessToken() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        String token = this.passwordManagementService.createToken(PasswordManagementQuery.builder().build());
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        context.getFlowScope().put("token", (Object)token);
        Assertions.assertEquals((Object)"error", (Object)this.initPasswordResetAction.execute((RequestContext)context).getId());
    }
}

