/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockParameterMap;

@EnabledIfListeningOnPort(port={25000})
@Tag(value="Mail")
public class SendForgotUsernameInstructionsActionEmailMessageBodyTests
extends BasePasswordManagementActionTests {
    private static RequestContext getRequestContext(MockHttpServletRequest request, MockHttpServletResponse response) {
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
        Mockito.when((Object)context.getFlashScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getRequestParameters()).thenReturn((Object)new MockParameterMap());
        Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        return context;
    }

    @Nested
    @TestPropertySource(properties={"spring.boot.config.CasPersonDirectoryTestConfiguration.enabled=false"})
    public class NoPrincipalResolutionTests
    extends BasePasswordManagementActionTests {
        @Autowired
        @Qualifier(value="sendForgotUsernameInstructionsAction")
        protected Action sendForgotUsernameInstructionsAction;

        @Test
        public void verifyBodyContainsUsername() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            RequestContext context = SendForgotUsernameInstructionsActionEmailMessageBodyTests.getRequestContext(request, response);
            request.setParameter("username", "casuser");
            request.setParameter("email", "casuser@apereo.org");
            Event resultEvent = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"success", (Object)resultEvent.getId());
            String resultAttributeName = new EventFactorySupport().getResultAttributeName();
            EmailCommunicationResult emailResult = (EmailCommunicationResult)resultEvent.getAttributes().get(resultAttributeName, EmailCommunicationResult.class);
            Assertions.assertTrue((boolean)emailResult.isSuccess());
            Assertions.assertEquals((Object)"Your current username is: casuser", (Object)emailResult.getBody());
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.pm.forgot-username.mail.text=classpath:ForgotUsernameEmailBody.groovy"})
    public class DefaultTests
    extends BasePasswordManagementActionTests {
        @Autowired
        @Qualifier(value="sendForgotUsernameInstructionsAction")
        protected Action sendForgotUsernameInstructionsAction;

        @Test
        public void verifyOp() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            RequestContext context = SendForgotUsernameInstructionsActionEmailMessageBodyTests.getRequestContext(request, response);
            request.setParameter("email", "casuser@apereo.org");
            Event result = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"success", (Object)result.getId());
        }

        @Test
        public void verifyBodyContainsUsername() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            RequestContext context = SendForgotUsernameInstructionsActionEmailMessageBodyTests.getRequestContext(request, response);
            request.setParameter("username", "casuser");
            request.setParameter("email", "casuser@apereo.org");
            Event resultEvent = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"success", (Object)resultEvent.getId());
            String resultAttributeName = new EventFactorySupport().getResultAttributeName();
            EmailCommunicationResult emailResult = (EmailCommunicationResult)resultEvent.getAttributes().get(resultAttributeName, EmailCommunicationResult.class);
            Assertions.assertTrue((boolean)emailResult.isSuccess());
            Assertions.assertEquals((Object)"Hello uid with email casuser@apereo.org, your affiliation is developer", (Object)emailResult.getBody());
        }
    }
}

