/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.expiration.MultiTimeUseOrTimeoutExpirationPolicy;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@EnabledIfListeningOnPort(port={25000})
@Tag(value="Mail")
public class SendPasswordResetInstructionsActionTests {

    @Nested
    @Import(value={PasswordManagementTestConfiguration.class})
    public class WithoutTokens
    extends BasePasswordManagementActionTests {
        @Test
        public void verifyNoLinkAction() throws Exception {
            MockRequestContext context = new MockRequestContext();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("username", "unknown");
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
            context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
            Assertions.assertEquals((Object)"error", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
        }
    }

    @Nested
    @SpringBootTest(classes={BasePasswordManagementActionTests.SharedTestConfiguration.class, CasPersonDirectoryTestConfiguration.class}, properties={"spring.mail.host=localhost", "spring.mail.port=25000", "cas.authn.pm.core.enabled=true", "cas.authn.pm.groovy.location=classpath:PasswordManagementService.groovy", "cas.authn.pm.forgot-username.mail.from=cas@example.org", "cas.authn.pm.reset.mail.from=cas@example.org", "cas.authn.pm.reset.security-questions-enabled=true", "cas.authn.pm.reset.number-of-uses=1"})
    public class MultiUseTests
    extends BasePasswordManagementActionTests {
        @Test
        public void verifyActionMultiUse() throws Exception {
            MockRequestContext context = new MockRequestContext();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("username", "casuser");
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
            context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
            Assertions.assertEquals((Object)"success", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
            Collection tickets = this.ticketRegistry.getTickets();
            Assertions.assertEquals((int)1, (int)tickets.size());
            Assertions.assertInstanceOf(MultiTimeUseOrTimeoutExpirationPolicy.class, (Object)((Ticket)tickets.iterator().next()).getExpirationPolicy());
        }
    }

    @Nested
    public class DefaultTests
    extends BasePasswordManagementActionTests {
        @BeforeEach
        public void setup() {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setRemoteAddr("223.456.789.000");
            request.setLocalAddr("123.456.789.000");
            request.addHeader("user-agent", (Object)"test");
            ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
            this.ticketRegistry.deleteAll();
        }

        @Test
        public void verifyAction() throws Exception {
            MockRequestContext context = new MockRequestContext();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("username", "casuser");
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
            context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
            Assertions.assertEquals((Object)"success", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
            Collection tickets = this.ticketRegistry.getTickets();
            Assertions.assertEquals((int)1, (int)tickets.size());
            Assertions.assertInstanceOf(HardTimeoutExpirationPolicy.class, (Object)((Ticket)tickets.iterator().next()).getExpirationPolicy());
        }

        @Test
        public void verifyNoPhoneOrEmail() throws Exception {
            MockRequestContext context = new MockRequestContext();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("username", "none");
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
            context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
            Assertions.assertEquals((Object)"error", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
        }

        @Test
        public void verifyNoUsername() throws Exception {
            MockRequestContext context = new MockRequestContext();
            MockHttpServletRequest request = new MockHttpServletRequest();
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
            context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
            Assertions.assertEquals((Object)"error", (Object)this.sendPasswordResetInstructionsAction.execute((RequestContext)context).getId());
        }
    }

    @TestConfiguration(value="PasswordManagementTestConfiguration", proxyBeanMethods=false)
    public static class PasswordManagementTestConfiguration {
        @Bean
        @Autowired
        public PasswordManagementService passwordChangeService() {
            PasswordManagementService service = (PasswordManagementService)Mockito.mock(PasswordManagementService.class);
            Mockito.when((Object)service.createToken((PasswordManagementQuery)Mockito.any())).thenReturn(null);
            Mockito.when((Object)service.findUsername((PasswordManagementQuery)Mockito.any())).thenReturn((Object)"casuser");
            Mockito.when((Object)service.findEmail((PasswordManagementQuery)Mockito.any())).thenReturn((Object)"casuser@example.org");
            return service;
        }
    }
}

